/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.spatial.BaseSpatialLuceneTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneSpatialLineStringTest
extends BaseSpatialLuceneTest {
    public static String LINEWKT = "LINESTRING(-149.8871332 61.1484656,-149.8871655 61.1489556,-149.8871569 61.15043,-149.8870366 61.1517722)";

    @Before
    public void initMore() {
        this.db.set(ODatabase.ATTRIBUTES.CUSTOM, (Object)"strictSql=false");
        OSchema schema = this.db.getMetadata().getSchema();
        OClass v = schema.getClass("V");
        OClass oClass = schema.createClass("Place");
        oClass.setSuperClass(v);
        oClass.createProperty("location", OType.EMBEDDED, schema.getClass("OLineString"));
        oClass.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("CREATE INDEX Place.location ON Place(location) SPATIAL ENGINE LUCENE")).execute(new Object[0]);
        ODocument linestring1 = new ODocument("Place");
        linestring1.field("name", (Object)"LineString1");
        linestring1.field("location", (Object)this.createLineString((List<List<Double>>)new ArrayList<List<Double>>(){
            {
                this.add(Arrays.asList(0.0, 0.0));
                this.add(Arrays.asList(3.0, 3.0));
            }
        }));
        ODocument linestring2 = new ODocument("Place");
        linestring2.field("name", (Object)"LineString2");
        linestring2.field("location", (Object)this.createLineString((List<List<Double>>)new ArrayList<List<Double>>(){
            {
                this.add(Arrays.asList(0.0, 1.0));
                this.add(Arrays.asList(0.0, 5.0));
            }
        }));
        this.db.save((ORecord)linestring1);
        this.db.save((ORecord)linestring2);
        this.db.command((OCommandRequest)new OCommandSQL("insert into Place set name = 'LineString3' , location = ST_GeomFromText('" + LINEWKT + "')")).execute(new Object[0]);
    }

    public ODocument createLineString(List<List<Double>> coordinates) {
        ODocument location = new ODocument("OLineString");
        location.field("coordinates", coordinates);
        return location;
    }

    @Test
    public void testLineStringWithoutIndex() throws IOException {
        this.db.command((OCommandRequest)new OCommandSQL("drop index Place.location")).execute(new Object[0]);
        this.queryLineString();
    }

    protected void queryLineString() {
        String query = "select * from Place where location && { 'shape' : { 'type' : 'OLineString' , 'coordinates' : [[1,2],[4,6]]} } ";
        List docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
        query = "select * from Place where location && 'LINESTRING(1 2, 4 6)' ";
        docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
        query = "select * from Place where location && ST_GeomFromText('LINESTRING(1 2, 4 6)') ";
        docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
        query = "select * from Place where location && 'POLYGON((-150.205078125 61.40723633876356,-149.2657470703125 61.40723633876356,-149.2657470703125 61.05562700886678,-150.205078125 61.05562700886678,-150.205078125 61.40723633876356))' ";
        docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
    }

    @Test
    public void testIndexingLineString() throws IOException {
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("Place.location");
        Assert.assertEquals((long)4L, (long)index.getSize());
        this.queryLineString();
    }
}

