/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.BaseSpatialLuceneTest;
import com.orientechnologies.spatial.shape.OGeometryCollectionShapeBuilder;
import com.orientechnologies.spatial.shape.OLineStringShapeBuilder;
import com.orientechnologies.spatial.shape.OMultiLineStringShapeBuilder;
import com.orientechnologies.spatial.shape.OMultiPointShapeBuilder;
import com.orientechnologies.spatial.shape.OMultiPolygonShapeBuilder;
import com.orientechnologies.spatial.shape.OPointShapeBuilder;
import com.orientechnologies.spatial.shape.OPolygonShapeBuilder;
import com.orientechnologies.spatial.shape.ORectangleShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeFactory;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class LuceneSpatialIOTest
extends BaseSpatialLuceneTest {
    @Test
    public void testPointIO() throws ParseException {
        ODocument doc = new ODocument("OPoint");
        doc.field("coordinates", (Object)new ArrayList<Double>(){
            {
                this.add(-100.0);
                this.add(45.0);
            }
        });
        OPointShapeBuilder builder = new OPointShapeBuilder();
        String p1 = builder.asText(doc);
        Assert.assertNotNull((Object)p1);
        Point point = this.context.makePoint(-100.0, 45.0);
        String p2 = this.context.getGeometryFrom((Shape)point).toText();
        Assert.assertEquals((Object)p2, (Object)p1);
        ODocument parsed = builder.toDoc(p2);
        Assert.assertEquals((Object)doc.field("coordinates"), (Object)parsed.field("coordinates"));
    }

    @Test
    public void testMultiPointIO() {
        ODocument doc = new ODocument("OMultiPoint");
        doc.field("coordinates", (Object)new ArrayList<List<Double>>(){
            {
                this.add(Arrays.asList(-71.160281, 42.258729));
                this.add(Arrays.asList(-71.160837, 42.259113));
                this.add(Arrays.asList(-71.161144, 42.25932));
            }
        });
        OMultiPointShapeBuilder builder = new OMultiPointShapeBuilder();
        String multiPoint = builder.asText(doc);
        ArrayList<Coordinate> points = new ArrayList<Coordinate>(){
            {
                this.add(new Coordinate(-71.160281, 42.258729));
                this.add(new Coordinate(-71.160837, 42.259113));
                this.add(new Coordinate(-71.161144, 42.25932));
            }
        };
        MultiPoint multiPoint1 = this.geometryFactory.createMultiPoint(points.toArray(new Coordinate[points.size()]));
        Assert.assertEquals((Object)multiPoint1.toText(), (Object)multiPoint);
    }

    @Test
    @Ignore
    public void testRectangleIO() {
        ODocument doc = this.rectangle();
        ORectangleShapeBuilder builder = new ORectangleShapeBuilder();
        String rect = builder.asText(doc);
        Assert.assertNotNull((Object)rect);
        Rectangle rectangle = this.context.makeRectangle(-45.0, 45.0, -30.0, 30.0);
        String rect1 = this.context.getGeometryFrom((Shape)rectangle).toText();
        Assert.assertEquals((Object)rect1, (Object)rect);
    }

    @Test
    public void testLineStringIO() {
        ODocument doc = new ODocument("OLineString");
        doc.field("coordinates", (Object)new ArrayList<List<Double>>(){
            {
                this.add(Arrays.asList(-71.160281, 42.258729));
                this.add(Arrays.asList(-71.160837, 42.259113));
                this.add(Arrays.asList(-71.161144, 42.25932));
            }
        });
        OLineStringShapeBuilder builder = new OLineStringShapeBuilder();
        String lineString = builder.asText(doc);
        Shape shape = this.context.makeLineString((List)new ArrayList<Point>(){
            {
                this.add(LuceneSpatialIOTest.this.context.makePoint(-71.160281, 42.258729));
                this.add(LuceneSpatialIOTest.this.context.makePoint(-71.160837, 42.259113));
                this.add(LuceneSpatialIOTest.this.context.makePoint(-71.161144, 42.25932));
            }
        });
        String lineString1 = this.context.getGeometryFrom(shape).toText();
        Assert.assertEquals((Object)lineString1, (Object)lineString);
    }

    @Test
    public void testMultiLineStringIO() {
        ODocument doc = new ODocument("OMultiLineString");
        doc.field("coordinates", (Object)new ArrayList<List<List<Double>>>(){
            {
                this.add(new ArrayList<List<Double>>(){
                    {
                        this.add(Arrays.asList(-71.160281, 42.258729));
                        this.add(Arrays.asList(-71.160837, 42.259113));
                        this.add(Arrays.asList(-71.161144, 42.25932));
                    }
                });
            }
        });
        OMultiLineStringShapeBuilder builder = new OMultiLineStringShapeBuilder();
        String multiLineString = builder.asText(doc);
        Shape shape = this.context.makeLineString((List)new ArrayList<Point>(){
            {
                this.add(LuceneSpatialIOTest.this.context.makePoint(-71.160281, 42.258729));
                this.add(LuceneSpatialIOTest.this.context.makePoint(-71.160837, 42.259113));
                this.add(LuceneSpatialIOTest.this.context.makePoint(-71.161144, 42.25932));
            }
        });
        JtsGeometry geometry = (JtsGeometry)shape;
        LineString lineString = (LineString)geometry.getGeom();
        MultiLineString multiLineString2 = this.geometryFactory.createMultiLineString(new LineString[]{lineString});
        String multiLineString1 = multiLineString2.toText();
        Assert.assertEquals((Object)multiLineString1, (Object)multiLineString);
    }

    @Test
    public void testPolygonNoHolesIO() {
        ODocument doc = new ODocument("OPolygon");
        doc.field("coordinates", (Object)new ArrayList<List<List<Double>>>(){
            {
                this.add(new ArrayList<List<Double>>(){
                    {
                        this.add(Arrays.asList(-45.0, 30.0));
                        this.add(Arrays.asList(45.0, 30.0));
                        this.add(Arrays.asList(45.0, -30.0));
                        this.add(Arrays.asList(-45.0, -30.0));
                        this.add(Arrays.asList(-45.0, 30.0));
                    }
                });
            }
        });
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(-45.0, 30.0));
        coordinates.add(new Coordinate(45.0, 30.0));
        coordinates.add(new Coordinate(45.0, -30.0));
        coordinates.add(new Coordinate(-45.0, -30.0));
        coordinates.add(new Coordinate(-45.0, 30.0));
        OPolygonShapeBuilder builder = new OPolygonShapeBuilder();
        String p1 = builder.asText(doc);
        Polygon polygon1 = this.geometryFactory.createPolygon(coordinates.toArray(new Coordinate[coordinates.size()]));
        String p2 = polygon1.toText();
        Assert.assertEquals((Object)p2, (Object)p1);
    }

    @Test
    public void testPolygonHolesIO() {
        ODocument doc = new ODocument("OPolygon");
        doc.field("coordinates", this.polygonCoordTestHole());
        Polygon polygon1 = this.polygonTestHole();
        OPolygonShapeBuilder builder = new OPolygonShapeBuilder();
        String p1 = builder.asText(doc);
        String p2 = polygon1.toText();
        Assert.assertEquals((Object)p2, (Object)p1);
    }

    @Test
    public void testMultiPolygon() throws IOException {
        OMultiPolygonShapeBuilder builder = new OMultiPolygonShapeBuilder();
        ODocument multiPolygon = this.loadMultiPolygon();
        MultiPolygon multiPolygon1 = this.createMultiPolygon();
        String m1 = builder.asText(multiPolygon);
        String m2 = multiPolygon1.toText();
        Assert.assertEquals((Object)m2, (Object)m1);
    }

    @Test
    public void testGeometryCollection() throws IOException {
        OGeometryCollectionShapeBuilder builder = new OGeometryCollectionShapeBuilder(OShapeFactory.INSTANCE);
        ODocument geometryCollection = this.geometryCollection();
        GeometryCollection collection = this.createGeometryCollection();
        String m1 = builder.asText(geometryCollection);
        String m2 = collection.toText();
        Assert.assertEquals((Object)m2, (Object)m1);
    }
}

