/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.spatial.BaseSpatialLuceneTest;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneSpatialGeometryCollectionTest
extends BaseSpatialLuceneTest {
    @Before
    public void init() {
        this.db.command((OCommandRequest)new OCommandSQL("create class test")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property test.name STRING")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property test.geometry EMBEDDED OGeometryCollection")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index test.geometry on test (geometry) SPATIAL engine lucene")).execute(new Object[0]);
    }

    @Test
    public void testGeoCollectionOutsideTx() {
        ODocument test1 = new ODocument("test");
        test1.field("name", (Object)"test1");
        ODocument geometry = new ODocument("OGeometryCollection");
        ODocument point = new ODocument("OPoint");
        point.field("coordinates", Arrays.asList(1.0, 2.0));
        ODocument polygon = new ODocument("OPolygon");
        polygon.field("coordinates", Arrays.asList(Arrays.asList(Arrays.asList(0.0, 0.0), Arrays.asList(10.0, 0.0), Arrays.asList(10.0, 10.0), Arrays.asList(0.0, 10.0), Arrays.asList(0.0, 0.0))));
        geometry.field("geometries", Arrays.asList(point, polygon));
        test1.field("geometry", (Object)geometry);
        test1.save();
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT from test where ST_Contains(geometry, ST_GeomFromText('POINT(1 1)')) = true")).execute(new Object[0]);
        Assert.assertEquals((long)execute.size(), (long)1L);
    }

    @Test
    public void testGeoCollectionInsideTransaction() {
        this.db.begin();
        ODocument test1 = new ODocument("test");
        test1.field("name", (Object)"test1");
        ODocument geometry = new ODocument("OGeometryCollection");
        ODocument point = new ODocument("OPoint");
        point.field("coordinates", Arrays.asList(1.0, 2.0));
        ODocument polygon = new ODocument("OPolygon");
        polygon.field("coordinates", Arrays.asList(Arrays.asList(Arrays.asList(0.0, 0.0), Arrays.asList(10.0, 0.0), Arrays.asList(10.0, 10.0), Arrays.asList(0.0, 10.0), Arrays.asList(0.0, 0.0))));
        geometry.field("geometries", Arrays.asList(point, polygon));
        test1.field("geometry", (Object)geometry);
        test1.save();
        this.db.commit();
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT from test where ST_Contains(geometry, ST_GeomFromText('POINT(1 1)')) = true")).execute(new Object[0]);
        Assert.assertEquals((long)execute.size(), (long)1L);
    }
}

