/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.spatial.BaseSpatialLuceneTest;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneSpatialFunctionFromGeoJSONTest
extends BaseSpatialLuceneTest {
    ODatabaseDocument db;
    OrientDB orientDB;

    @Before
    public void before() {
        this.orientDB = new OrientDB("embedded:.", OrientDBConfig.defaultConfig());
        this.orientDB.create("test", ODatabaseType.MEMORY);
        this.db = this.orientDB.open("test", "admin", "admin");
    }

    @After
    public void after() {
        this.db.close();
        this.orientDB.drop("test");
        this.orientDB.close();
    }

    @Test
    public void geoPointTest() {
        this.queryAndMatch("POINT(11.11111 12.22222)", "{\"type\":\"Point\",\"coordinates\":[11.11111,12.22222]}");
    }

    @Test
    public void geoLineStringTest() {
        this.queryAndMatch("LINESTRING(1 2 , 3 4)", "{\"type\":\"LineString\",\"coordinates\":[[1,2],[3,4]]}");
    }

    protected void queryAndMatch(final String input, String match) {
        OResultSet query = this.db.query("SELECT ST_AsGeoJSON(ST_GeomFromText(:geo)) as geo;", (Map)new HashMap(){
            {
                this.put("geo", input);
            }
        });
        OResult result = (OResult)query.stream().findFirst().get();
        String geo = (String)result.getProperty("geo");
        Assert.assertEquals((Object)match, (Object)geo);
    }
}

