/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.spatial.BaseSpatialLuceneTest;
import java.text.ParseException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.shape.Shape;

public class LuceneSpatialFunctionAsTextTest
extends BaseSpatialLuceneTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass v = schema.getClass("V");
        OClass oClass = schema.createClass("Location");
        oClass.setSuperClass(v);
        oClass.createProperty("geometry", OType.EMBEDDED, schema.getClass("OShape"));
        oClass.createProperty("name", OType.STRING);
        this.initData();
    }

    private void initData() {
        this.createLocation("OPoint", this.point());
        this.createLocation("OMultiPoint", this.multiPoint());
        this.createLocation("OLineString", this.lineStringDoc());
        this.createLocation("OMultiLineString", this.multiLineString());
        this.createLocation("ORectangle", this.rectangle());
        this.createLocation("OPolygon", this.polygon());
        this.createLocation("OMultiPolygon", this.loadMultiPolygon());
        this.createLocation("OGeometryCollection", this.geometryCollection());
    }

    protected void createLocation(String name, ODocument geometry) {
        ODocument doc = new ODocument("Location");
        doc.field("name", (Object)name);
        doc.field("geometry", (Object)geometry);
        this.db.save((ORecord)doc);
    }

    @Test
    public void testPoint() {
        this.queryAndAssertGeom("OPoint", "POINT (50 50)");
    }

    protected void queryAndAssertGeom(String name, String wkt) {
        List results = (List)this.db.command((OCommandRequest)new OCommandSQL("select *, ST_AsText(geometry) as text from Location where name = ? ")).execute(new Object[]{name});
        Assert.assertEquals((long)1L, (long)results.size());
        ODocument doc = (ODocument)results.iterator().next();
        String asText = (String)doc.field("text");
        Assert.assertNotNull((Object)asText);
        Assert.assertEquals((Object)asText, (Object)wkt);
    }

    @Test
    public void testMultiPoint() {
        this.queryAndAssertGeom("OMultiPoint", "MULTIPOINT ((-71.160281 42.258729), (-71.160837 42.259113), (-71.161144 42.25932))");
    }

    @Test
    public void testLineString() {
        this.queryAndAssertGeom("OLineString", "LINESTRING (-71.160281 42.258729, -71.160837 42.259113, -71.161144 42.25932)");
    }

    @Test
    public void testMultiLineString() {
        this.queryAndAssertGeom("OMultiLineString", "MULTILINESTRING ((-71.160281 42.258729, -71.160837 42.259113, -71.161144 42.25932))");
    }

    @Test
    @Ignore
    public void testRectangle() {
        this.queryAndAssertGeom("ORectangle", "POLYGON ((-45 -30, -45 30, 45 30, 45 -30, -45 -30))");
    }

    @Test
    public void testBugEnvelope() {
        try {
            Shape shape = this.context.readShapeFromWkt("POLYGON ((-45 -30, -45 30, 45 30, 45 -30, -45 -30))");
            Geometry geometryFrom = this.context.getGeometryFrom(shape);
            Assert.assertEquals((Object)geometryFrom.toText(), (Object)"POLYGON ((-45 -30, -45 30, 45 30, 45 -30, -45 -30))");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testPolygon() {
        this.queryAndAssertGeom("OPolygon", "POLYGON ((-71.1776585052917 42.3902909739571, -71.1776820268866 42.3903701743239, -71.1776063012595 42.3903825660754, -71.1775826583081 42.3903033653531, -71.1776585052917 42.3902909739571))");
    }

    @Test
    public void testGeometryCollection() {
        this.queryAndAssertGeom("OGeometryCollection", "GEOMETRYCOLLECTION (POINT (4 6), LINESTRING (4 6, 7 10))");
    }

    @Test
    public void testMultiPolygon() {
        this.queryAndAssertGeom("OMultiPolygon", "MULTIPOLYGON (((15.520376 38.231155, 15.160243 37.444046, 15.309898 37.134219, 15.099988 36.619987, 14.335229 36.996631, 13.826733 37.104531, 12.431004 37.61295, 12.570944 38.126381, 13.741156 38.034966, 14.761249 38.143874, 15.520376 38.231155)), ((9.210012 41.209991, 9.809975 40.500009, 9.669519 39.177376, 9.214818 39.240473, 8.806936 38.906618, 8.428302 39.171847, 8.388253 40.378311, 8.159998 40.950007, 8.709991 40.899984, 9.210012 41.209991)), ((12.376485 46.767559, 13.806475 46.509306, 13.69811 46.016778, 13.93763 45.591016, 13.141606 45.736692, 12.328581 45.381778, 12.383875 44.885374, 12.261453 44.600482, 12.589237 44.091366, 13.526906 43.587727, 14.029821 42.761008, 15.14257 41.95514, 15.926191 41.961315, 16.169897 41.740295, 15.889346 41.541082, 16.785002 41.179606, 17.519169 40.877143, 18.376687 40.355625, 18.480247 40.168866, 18.293385 39.810774, 17.73838 40.277671, 16.869596 40.442235, 16.448743 39.795401, 17.17149 39.4247, 17.052841 38.902871, 16.635088 38.843572, 16.100961 37.985899, 15.684087 37.908849, 15.687963 38.214593, 15.891981 38.750942, 16.109332 38.964547, 15.718814 39.544072, 15.413613 40.048357, 14.998496 40.172949, 14.703268 40.60455, 14.060672 40.786348, 13.627985 41.188287, 12.888082 41.25309, 12.106683 41.704535, 11.191906 42.355425, 10.511948 42.931463, 10.200029 43.920007, 9.702488 44.036279, 8.888946 44.366336, 8.428561 44.231228, 7.850767 43.767148, 7.435185 43.693845, 7.549596 44.127901, 7.007562 44.254767, 6.749955 45.028518, 7.096652 45.333099, 6.802355 45.70858, 6.843593 45.991147, 7.273851 45.776948, 7.755992 45.82449, 8.31663 46.163642, 8.489952 46.005151, 8.966306 46.036932, 9.182882 46.440215, 9.922837 46.314899, 10.363378 46.483571, 10.442701 46.893546, 11.048556 46.751359, 11.164828 46.941579, 12.153088 47.115393, 12.376485 46.767559)))");
    }
}

