/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneSpatialFunctionAsGeoJSONTest {
    ODatabaseDocument db;
    OrientDB orientDB;

    @Before
    public void before() {
        this.orientDB = new OrientDB("embedded:.", OrientDBConfig.defaultConfig());
        this.orientDB.create("test", ODatabaseType.MEMORY);
        this.db = this.orientDB.open("test", "admin", "admin");
    }

    @After
    public void after() {
        this.db.close();
        this.orientDB.drop("test");
        this.orientDB.close();
    }

    @Test
    public void geoPointTest() {
        this.queryAndMatch("POINT(11.11111 12.22222)", "{\"type\":\"Point\",\"coordinates\":[11.11111,12.22222]}");
    }

    @Test
    public void geoLineStringTest() {
        this.queryAndMatch("LINESTRING(1 2 , 3 4)", "{\"type\":\"LineString\",\"coordinates\":[[1,2],[3,4]]}");
    }

    protected void queryAndMatch(final String wkt, final String geoJson) {
        OResultSet query = this.db.query("SELECT ST_GeomFromText(:wkt) as wkt,ST_GeomFromGeoJSON(:geoJson) as geoJson;", (Map)new HashMap(){
            {
                this.put("geoJson", geoJson);
                this.put("wkt", wkt);
            }
        });
        OResult result = (OResult)query.stream().findFirst().get();
        OResult jsonGeom = (OResult)result.getProperty("geoJson");
        OResult wktGeom = (OResult)result.getProperty("wkt");
        this.assertGeometry(wktGeom, jsonGeom);
    }

    private void assertGeometry(OResult source, OResult geom) {
        Assert.assertNotNull((Object)geom);
        Assert.assertNotNull((Object)geom.getProperty("coordinates"));
        Assert.assertEquals((Object)((String)source.getProperty("@class")), (Object)((String)geom.getProperty("@class")));
        Assert.assertEquals((Object)geom.getProperty("coordinates"), (Object)source.getProperty("coordinates"));
    }
}

