/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.File;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneSpatialDropTest {
    private int insertcount;
    private String dbName;

    @Before
    public void setUp() throws Exception {
        this.dbName = "plocal:./target/databases/" + this.getClass().getSimpleName();
        this.insertcount = 100;
        ODatabaseDocumentTx db = new ODatabaseDocumentTx(this.dbName);
        db.create();
        OClass test = db.getMetadata().getSchema().createClass("test");
        test.createProperty("name", OType.STRING);
        test.createProperty("latitude", OType.DOUBLE).setMandatory(false);
        test.createProperty("longitude", OType.DOUBLE).setMandatory(false);
        db.command((OCommandRequest)new OCommandSQL("create index test.name on test (name) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        db.command((OCommandRequest)new OCommandSQL("create index test.ll on test (latitude,longitude) SPATIAL ENGINE LUCENE")).execute(new Object[0]);
        db.close();
    }

    @Test
    public void testDeleteLuceneIndex1() {
        OPartitionedDatabasePool dbPool = new OPartitionedDatabasePool(this.dbName, "admin", "admin");
        ODatabaseDocumentTx db = dbPool.acquire();
        this.fillDb(db, this.insertcount);
        db.close();
        db = dbPool.acquire();
        OSQLSynchQuery query = new OSQLSynchQuery("select from test where [latitude,longitude] WITHIN [[50.0,8.0],[51.0,9.0]]");
        List result = (List)db.command((OCommandRequest)query).execute(new Object[0]);
        Assert.assertEquals((long)this.insertcount, (long)result.size());
        db.close();
        dbPool.close();
        db = (ODatabaseDocumentTx)new ODatabaseDocumentTx(this.dbName).open("admin", "admin");
        db.drop();
        File dbFolder = new File(this.dbName);
        Assert.assertEquals((Object)false, (Object)dbFolder.exists());
    }

    private void fillDb(ODatabaseDocumentTx db, int count) {
        for (int i = 0; i < count; ++i) {
            ODocument doc = new ODocument("test");
            doc.field("name", (Object)("TestInsert" + i));
            doc.field("latitude", (Object)(50.0 + (double)i * 1.0E-6));
            doc.field("longitude", (Object)(8.0 + (double)i * 1.0E-6));
            db.save((ORecord)doc);
        }
        OSQLSynchQuery query = new OSQLSynchQuery("select * from test");
        List result = (List)db.command((OCommandRequest)query).execute(new Object[0]);
        Assert.assertEquals((long)count, (long)result.size());
    }
}

