/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.handler.OAutomaticBackup;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.zip.GZIPInputStream;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class LuceneSpatialAutomaticBackupRestoreTest {
    private static final String DBNAME = "OLuceneAutomaticBackupRestoreTest";
    public File tempFolder;
    private OrientDB orientDB;
    private String URL = null;
    private String BACKUPDIR = null;
    private String BACKUFILE = null;
    private OServer server;
    private ODatabaseDocumentInternal db;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        Assume.assumeFalse((boolean)Platform.isWindows());
        String buildDirectory = System.getProperty("buildDirectory", "target");
        File buildDirectoryFile = new File(buildDirectory);
        this.tempFolder = new File(buildDirectoryFile, this.name.getMethodName());
        OFileUtils.deleteRecursively((File)this.tempFolder);
        Assert.assertTrue((boolean)this.tempFolder.mkdirs());
        this.server = new OServer(){

            public Map<String, String> getAvailableStorageNames() {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put(LuceneSpatialAutomaticBackupRestoreTest.DBNAME, LuceneSpatialAutomaticBackupRestoreTest.this.URL);
                return result;
            }
        };
        this.server.startup();
        System.setProperty("ORIENTDB_HOME", this.tempFolder.getAbsolutePath());
        String path = this.tempFolder.getAbsolutePath() + File.separator + "databases";
        this.orientDB = this.server.getContext();
        this.URL = "plocal:" + path + File.separator + DBNAME;
        this.BACKUPDIR = this.tempFolder.getAbsolutePath() + File.separator + "backups";
        this.BACKUFILE = this.BACKUPDIR + File.separator + DBNAME;
        File config = new File(this.tempFolder, "config");
        Assert.assertTrue((boolean)config.mkdirs());
        this.dropIfExists();
        this.orientDB.create(DBNAME, ODatabaseType.PLOCAL);
        this.db = (ODatabaseDocumentInternal)this.orientDB.open(DBNAME, "admin", "admin");
        this.db.command((OCommandRequest)new OCommandSQL("create class City ")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property City.name string")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index City.name on City (name) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property City.location EMBEDDED OPOINT")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("CREATE INDEX City.location ON City(location) SPATIAL ENGINE LUCENE")).execute(new Object[0]);
        ODocument rome = this.newCity("Rome", 12.5, 41.9);
        this.db.save((Object)rome);
    }

    protected ODocument newCity(String name, final Double longitude, final Double latitude) {
        ODocument city = new ODocument("City").field("name", (Object)name).field("location", (Object)new ODocument("OPoint").field("coordinates", (Object)new ArrayList<Double>(){
            {
                this.add(longitude);
                this.add(latitude);
            }
        }));
        return city;
    }

    private void dropIfExists() {
        if (this.orientDB.exists(DBNAME)) {
            this.orientDB.drop(DBNAME);
        }
    }

    @After
    public void tearDown() throws Exception {
        if (!Platform.isWindows()) {
            this.dropIfExists();
            this.tempFolder.delete();
        }
    }

    @Test
    public void shouldBackupAndRestore() throws IOException, InterruptedException {
        String query = "select * from City where  ST_WITHIN(location,'POLYGON ((12.314015 41.8262816, 12.314015 41.963125, 12.6605063 41.963125, 12.6605063 41.8262816, 12.314015 41.8262816))') = true";
        List docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
        String jsonConfig = OIOUtils.readStreamAsString((InputStream)this.getClass().getClassLoader().getResourceAsStream("automatic-backup.json"));
        ODocument doc = new ODocument().fromJSON(jsonConfig).field("enabled", (Object)true).field("targetFileName", (Object)"${DBNAME}.zip").field("targetDirectory", (Object)this.BACKUPDIR).field("dbInclude", (Object)new String[]{DBNAME}).field("firstTime", (Object)new SimpleDateFormat("HH:mm:ss").format(new Date(System.currentTimeMillis() + 2000L)));
        OIOUtils.writeFile((File)new File(this.tempFolder.getAbsolutePath() + "/config/automatic-backup.json"), (String)doc.toJSON());
        OAutomaticBackup aBackup = new OAutomaticBackup();
        OServerParameterConfiguration[] config = new OServerParameterConfiguration[]{};
        aBackup.config(this.server, config);
        final CountDownLatch latch = new CountDownLatch(1);
        aBackup.registerListener(new OAutomaticBackup.OAutomaticBackupListener(){

            public void onBackupCompleted(String database) {
                System.out.println("complete ");
                latch.countDown();
            }

            public void onBackupError(String database, Exception e) {
                System.out.println("e.getMessage() = " + e.getMessage());
            }
        });
        latch.await();
        aBackup.sendShutdown();
        this.dropIfExists();
        this.db = this.createAndOpen();
        FileInputStream stream = new FileInputStream(new File(this.BACKUFILE + ".zip"));
        this.db.restore((InputStream)stream, null, null, null);
        this.db.close();
        this.db = this.open();
        Assertions.assertThat((long)this.db.countClass("City")).isEqualTo(1L);
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("City.location");
        Assertions.assertThat((Comparable)index).isNotNull();
        Assertions.assertThat((String)index.getType()).isEqualTo((Object)OClass.INDEX_TYPE.SPATIAL.name());
        Assertions.assertThat((List)this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0])).hasSize(1);
    }

    @Test
    public void shouldExportImport() throws IOException, InterruptedException {
        String query = "select * from City where  ST_WITHIN(location,'POLYGON ((12.314015 41.8262816, 12.314015 41.963125, 12.6605063 41.963125, 12.6605063 41.8262816, 12.314015 41.8262816))') = true";
        List docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
        String jsonConfig = OIOUtils.readStreamAsString((InputStream)this.getClass().getClassLoader().getResourceAsStream("automatic-backup.json"));
        ODocument doc = new ODocument().fromJSON(jsonConfig).field("enabled", (Object)true).field("targetFileName", (Object)"${DBNAME}.json").field("targetDirectory", (Object)this.BACKUPDIR).field("mode", (Object)"EXPORT").field("dbInclude", (Object)new String[]{DBNAME}).field("firstTime", (Object)new SimpleDateFormat("HH:mm:ss").format(new Date(System.currentTimeMillis() + 2000L)));
        OIOUtils.writeFile((File)new File(this.tempFolder.getAbsolutePath() + "/config/automatic-backup.json"), (String)doc.toJSON());
        OAutomaticBackup aBackup = new OAutomaticBackup();
        OServerParameterConfiguration[] config = new OServerParameterConfiguration[]{};
        aBackup.config(this.server, config);
        final CountDownLatch latch = new CountDownLatch(1);
        aBackup.registerListener(new OAutomaticBackup.OAutomaticBackupListener(){

            public void onBackupCompleted(String database) {
                latch.countDown();
            }

            public void onBackupError(String database, Exception e) {
                latch.countDown();
            }
        });
        latch.await();
        aBackup.sendShutdown();
        this.db.close();
        this.dropIfExists();
        this.db = this.createAndOpen();
        GZIPInputStream stream = new GZIPInputStream(new FileInputStream(this.BACKUFILE + ".json.gz"));
        new ODatabaseImport(this.db, (InputStream)stream, new OCommandOutputListener(){

            public void onMessage(String s) {
            }
        }).importDatabase();
        this.db.close();
        this.db = this.open();
        Assertions.assertThat((long)this.db.countClass("City")).isEqualTo(1L);
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("City.location");
        Assertions.assertThat((Comparable)index).isNotNull();
        Assertions.assertThat((String)index.getType()).isEqualTo((Object)OClass.INDEX_TYPE.SPATIAL.name());
        Assertions.assertThat((List)this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0])).hasSize(1);
    }

    private ODatabaseDocumentInternal createAndOpen() {
        this.orientDB.create(DBNAME, ODatabaseType.PLOCAL);
        return this.open();
    }

    private ODatabaseDocumentInternal open() {
        return (ODatabaseDocumentInternal)this.orientDB.open(DBNAME, "admin", "admin");
    }
}

