/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OLuceneTransactionQueryTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        OClass c1 = this.db.createVertexClass("C1");
        c1.createProperty("p1", OType.STRING);
        c1.createIndex("C1.p1", "FULLTEXT", null, null, "LUCENE", new String[]{"p1"});
    }

    @Test
    public void testRollback() {
        ODocument doc = new ODocument("c1");
        doc.field("p1", (Object)"abc");
        this.db.begin();
        this.db.save((Object)doc);
        String query = "select from C1 where search_fields(['p1'], 'abc' )=true ";
        OResultSet vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        this.db.rollback();
        vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(0);
    }

    @Test
    public void txRemoveTest() {
        this.db.begin();
        ODocument doc = new ODocument("c1");
        doc.field("p1", (Object)"abc");
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("C1.p1");
        this.db.save((Object)doc);
        String query = "select from C1 where search_fields(['p1'], 'abc' )=true ";
        OResultSet vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assertions.assertThat((long)index.getSize()).isEqualTo(2L);
        this.db.commit();
        vertices = this.db.command(query, new Object[0]);
        List results = vertices.stream().collect(Collectors.toList());
        Assertions.assertThat(results).hasSize(1);
        Assertions.assertThat((long)index.getSize()).isEqualTo(2L);
        this.db.begin();
        doc = new ODocument("c1");
        doc.field("p1", (Object)"abc");
        this.db.delete(((OElement)((OResult)results.get(0)).getElement().get()).getIdentity());
        vertices = this.db.query(query, new Object[0]);
        Collection coll = (Collection)index.get((Object)"abc");
        Assertions.assertThat((Iterable)coll).hasSize(0);
        Assertions.assertThat((Iterator)vertices).hasSize(0);
        Iterator iterator = coll.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        Assert.assertEquals((long)i, (long)0L);
        Assertions.assertThat((long)index.getSize()).isEqualTo(1L);
        vertices.close();
        this.db.rollback();
        query = "select from C1 where search_fields(['p1'], 'abc' )=true ";
        vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assertions.assertThat((long)index.getSize()).isEqualTo(2L);
        vertices.close();
    }

    @Test
    public void txUpdateTest() {
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("C1.p1");
        OClass c1 = this.db.getMetadata().getSchema().getClass("C1");
        try {
            c1.truncate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)index.getSize(), (long)0L);
        this.db.begin();
        ODocument doc = new ODocument("c1");
        doc.field("p1", (Object)"update");
        this.db.save((Object)doc);
        String query = "select from C1 where search_fields(['p1'], \"update\")=true ";
        OResultSet vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)1L, (long)index.getSize());
        this.db.commit();
        vertices = this.db.command(query, new Object[0]);
        List results = vertices.stream().collect(Collectors.toList());
        Collection coll = (Collection)index.get((Object)"update");
        Assertions.assertThat(results).hasSize(1);
        Assertions.assertThat((Iterable)coll).hasSize(1);
        Assertions.assertThat((long)index.getSize()).isEqualTo(1L);
        this.db.begin();
        OResult record = (OResult)results.get(0);
        OElement element = (OElement)record.getElement().get();
        element.setProperty("p1", (Object)"removed");
        this.db.save((Object)element);
        vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(0);
        Assert.assertEquals((long)1L, (long)index.getSize());
        query = "select from C1 where search_fields(['p1'], \"removed\")=true ";
        vertices = this.db.command(query, new Object[0]);
        coll = (Collection)index.get((Object)"removed");
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)1L, (long)coll.size());
        this.db.rollback();
        query = "select from C1 where search_fields(['p1'], \"update\")=true ";
        vertices = this.db.command(query, new Object[0]);
        coll = (Collection)index.get((Object)"update");
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assertions.assertThat((Iterable)coll).hasSize(1);
        Assertions.assertThat((long)index.getSize()).isEqualTo(1L);
    }

    @Test
    public void txUpdateTestComplex() {
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("C1.p1");
        OClass c1 = this.db.getMetadata().getSchema().getClass("C1");
        try {
            c1.truncate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)index.getSize(), (long)0L);
        this.db.begin();
        ODocument doc = new ODocument("c1");
        doc.field("p1", (Object)"abc");
        ODocument doc1 = new ODocument("c1");
        doc1.field("p1", (Object)"abc");
        this.db.save((Object)doc1);
        this.db.save((Object)doc);
        this.db.commit();
        this.db.begin();
        doc.field("p1", (Object)"removed");
        this.db.save((Object)doc);
        String query = "select from C1 where search_fields(['p1'], \"abc\")=true ";
        OResultSet vertices = this.db.command(query, new Object[0]);
        Collection coll = (Collection)index.get((Object)"abc");
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)1L, (long)coll.size());
        Iterator iterator = coll.iterator();
        int i = 0;
        ORecordId rid = null;
        while (iterator.hasNext()) {
            rid = (ORecordId)iterator.next();
            ++i;
        }
        Assert.assertEquals((long)i, (long)1L);
        Assert.assertEquals((Object)doc1.getIdentity().toString(), (Object)rid.getIdentity().toString());
        Assert.assertEquals((long)index.getSize(), (long)2L);
        query = "select from C1 where search_fields(['p1'], \"removed\")=true ";
        vertices = this.db.command(query, new Object[0]);
        coll = (Collection)index.get((Object)"removed");
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)coll.size(), (long)1L);
        this.db.rollback();
        query = "select from C1 where search_fields(['p1'], \"abc\")=true ";
        vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(2);
        Assert.assertEquals((long)index.getSize(), (long)2L);
    }
}

