/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class OLuceneTransactionEmbeddedQueryTest
extends OLuceneBaseTest {
    @Before
    public void setUp() throws Exception {
        OClass c1 = this.db.createVertexClass("C1");
        c1.createProperty("p1", OType.EMBEDDEDLIST, OType.STRING);
        c1.createIndex("C1.p1", "FULLTEXT", null, null, "LUCENE", new String[]{"p1"});
    }

    @Test
    public void testRollback() {
        ODocument doc = new ODocument("c1");
        doc.field("p1", (Object)new String[]{"abc"});
        this.db.begin();
        this.db.save((Object)doc);
        String query = "select from C1 where search_class( \"abc\")=true ";
        OResultSet vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        this.db.rollback();
        query = "select from C1 where search_class( \"abc\")=true  ";
        vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(0);
    }

    @Test
    public void txRemoveTest() {
        this.db.begin();
        ODocument doc = new ODocument("c1");
        doc.field("p1", (Object)new String[]{"abc"});
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("C1.p1");
        this.db.save((Object)doc);
        String query = "select from C1 where search_class( \"abc\")=true";
        OResultSet vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)index.getSize(), (long)2L);
        this.db.commit();
        vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)index.getSize(), (long)2L);
        this.db.begin();
        this.db.delete((Object)doc);
        vertices = this.db.command(query, new Object[0]);
        Collection coll = (Collection)index.get((Object)"abc");
        Assertions.assertThat((Iterator)vertices).hasSize(0);
        Assert.assertEquals((long)coll.size(), (long)0L);
        Iterator iterator = coll.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        Assert.assertEquals((long)i, (long)0L);
        Assert.assertEquals((long)index.getSize(), (long)1L);
        this.db.rollback();
        vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)index.getSize(), (long)2L);
    }

    @Test
    @Ignore
    public void txUpdateTest() {
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("C1.p1");
        Assert.assertEquals((long)index.getSize(), (long)0L);
        this.db.begin();
        ODocument doc = new ODocument("c1");
        doc.field("p1", (Object)new String[]{"update removed", "update fixed"});
        this.db.save((Object)doc);
        String query = "select from C1 where search_class(\"update\")=true ";
        OResultSet vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)index.getSize(), (long)2L);
        this.db.commit();
        vertices = this.db.command(query, new Object[0]);
        Collection coll = (Collection)index.get((Object)"update");
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)coll.size(), (long)2L);
        Assert.assertEquals((long)index.getSize(), (long)2L);
        this.db.begin();
        Collection p1 = (Collection)doc.field("p1");
        p1.remove("update removed");
        this.db.save((Object)doc);
        vertices = this.db.command(query, new Object[0]);
        coll = (Collection)index.get((Object)"update");
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)coll.size(), (long)1L);
        Assert.assertEquals((long)index.getSize(), (long)1L);
        vertices = this.db.command(query, new Object[0]);
        coll = (Collection)index.get((Object)"update");
        Assert.assertEquals((long)coll.size(), (long)1L);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        this.db.rollback();
        vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)index.getSize(), (long)2L);
    }

    @Test
    public void txUpdateTestComplex() {
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("C1.p1");
        Assert.assertEquals((long)index.getSize(), (long)1L);
        this.db.begin();
        ODocument doc = new ODocument("c1");
        doc.field("p1", (Object)new String[]{"abc"});
        ODocument doc1 = new ODocument("c1");
        doc1.field("p1", (Object)new String[]{"abc"});
        this.db.save((Object)doc1);
        this.db.save((Object)doc);
        this.db.commit();
        this.db.begin();
        doc.field("p1", (Object)new String[]{"removed"});
        this.db.save((Object)doc);
        String query = "select from C1 where p1 lucene \"abc\"";
        List vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Collection coll = (Collection)index.get((Object)"abc");
        Assert.assertEquals((long)vertices.size(), (long)1L);
        Assert.assertEquals((long)coll.size(), (long)1L);
        Iterator iterator = coll.iterator();
        int i = 0;
        ORecordId rid = null;
        while (iterator.hasNext()) {
            rid = (ORecordId)iterator.next();
            ++i;
        }
        Assert.assertEquals((long)i, (long)1L);
        Assert.assertEquals((Object)doc1.getIdentity().toString(), (Object)rid.getIdentity().toString());
        Assert.assertEquals((long)index.getSize(), (long)3L);
        query = "select from C1 where p1 lucene \"removed\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        coll = (Collection)index.get((Object)"removed");
        Assert.assertEquals((long)vertices.size(), (long)1L);
        Assert.assertEquals((long)coll.size(), (long)1L);
        this.db.rollback();
        query = "select from C1 where p1 lucene \"abc\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assert.assertEquals((long)vertices.size(), (long)2L);
        Assert.assertEquals((long)index.getSize(), (long)3L);
    }
}

