/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OLuceneTransactionCompositeQueryTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        OClass c1 = this.db.createVertexClass("Foo");
        c1.createProperty("name", OType.STRING);
        c1.createProperty("bar", OType.STRING);
        c1.createIndex("Foo.bar", "FULLTEXT", null, null, "LUCENE", new String[]{"bar"});
        c1.createIndex("Foo.name", "NOTUNIQUE", null, null, "SBTREE", new String[]{"name"});
    }

    @Test
    public void testRollback() {
        ODocument doc = new ODocument("Foo");
        doc.field("name", (Object)"Test");
        doc.field("bar", (Object)"abc");
        this.db.begin();
        this.db.save((Object)doc);
        String query = "select from Foo where name = 'Test' and SEARCH_CLASS(\"abc\") =true ";
        OResultSet vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        vertices.close();
        this.db.rollback();
        query = "select from Foo where name = 'Test' and SEARCH_CLASS(\"abc\") = true ";
        vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(0);
        vertices.close();
    }

    @Test
    public void txRemoveTest() {
        this.db.begin();
        ODocument doc = new ODocument("Foo");
        doc.field("name", (Object)"Test");
        doc.field("bar", (Object)"abc");
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("Foo.bar");
        this.db.save((Object)doc);
        this.db.commit();
        this.db.begin();
        this.db.delete((Object)doc);
        String query = "select from Foo where name = 'Test' and  SEARCH_CLASS(\"abc\") = true ";
        OResultSet vertices = this.db.command(query, new Object[0]);
        Collection coll = (Collection)index.get((Object)"abc");
        Assertions.assertThat((Iterator)vertices).hasSize(0);
        Assert.assertEquals((long)coll.size(), (long)0L);
        Assert.assertEquals((long)index.getSize(), (long)1L);
        vertices.close();
        this.db.rollback();
        query = "select from Foo where name = 'Test' and SEARCH_CLASS(\"abc\") = true ";
        vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)index.getSize(), (long)2L);
        vertices.close();
    }

    @Test
    public void txUpdateTest() {
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("Foo.bar");
        OClass c1 = this.db.getMetadata().getSchema().getClass("Foo");
        try {
            c1.truncate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)index.getSize(), (long)0L);
        this.db.begin();
        ODocument doc = new ODocument("Foo");
        doc.field("name", (Object)"Test");
        doc.field("bar", (Object)"abc");
        this.db.save((Object)doc);
        this.db.commit();
        this.db.begin();
        doc.field("bar", (Object)"removed");
        this.db.save((Object)doc);
        String query = "select from Foo where name = 'Test' and SEARCH_CLASS(\"abc\") =true";
        OResultSet vertices = this.db.query(query, new Object[0]);
        Collection coll = (Collection)index.get((Object)"abc");
        Assertions.assertThat((Iterator)vertices).hasSize(0);
        Assert.assertEquals((long)coll.size(), (long)0L);
        Iterator iterator = coll.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        Assert.assertEquals((long)i, (long)0L);
        Assert.assertEquals((long)index.getSize(), (long)1L);
        vertices.close();
        query = "select from Foo where name = 'Test' and SEARCH_CLASS(\"removed\")=true ";
        vertices = this.db.query(query, new Object[0]);
        coll = (Collection)index.get((Object)"removed");
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)coll.size(), (long)1L);
        vertices.close();
        this.db.rollback();
        query = "select from Foo where name = 'Test' and SEARCH_CLASS (\"abc\")=true ";
        vertices = this.db.command(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)index.getSize(), (long)1L);
        vertices.close();
    }

    @Test
    public void txUpdateTestComplex() {
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("Foo.bar");
        OClass c1 = this.db.getMetadata().getSchema().getClass("Foo");
        try {
            c1.truncate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)index.getSize(), (long)0L);
        this.db.begin();
        ODocument doc = new ODocument("Foo");
        doc.field("name", (Object)"Test");
        doc.field("bar", (Object)"abc");
        ODocument doc1 = new ODocument("Foo");
        doc1.field("name", (Object)"Test");
        doc1.field("bar", (Object)"abc");
        this.db.save((Object)doc1);
        this.db.save((Object)doc);
        this.db.commit();
        this.db.begin();
        doc.field("bar", (Object)"removed");
        this.db.save((Object)doc);
        String query = "select from Foo where name = 'Test' and SEARCH_CLASS(\"abc\")=true ";
        OResultSet vertices = this.db.query(query, new Object[0]);
        Collection coll = (Collection)index.get((Object)"abc");
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)1L, (long)coll.size());
        Iterator iterator = coll.iterator();
        int i = 0;
        ORecordId rid = null;
        while (iterator.hasNext()) {
            rid = (ORecordId)iterator.next();
            ++i;
        }
        Assert.assertEquals((long)1L, (long)i);
        Assert.assertEquals((Object)rid.getIdentity().toString(), (Object)doc1.getIdentity().toString());
        Assert.assertEquals((long)2L, (long)index.getSize());
        vertices.close();
        query = "select from Foo where name = 'Test' and SEARCH_CLASS(\"removed\" )=true";
        vertices = this.db.query(query, new Object[0]);
        coll = (Collection)index.get((Object)"removed");
        Assertions.assertThat((Iterator)vertices).hasSize(1);
        Assert.assertEquals((long)1L, (long)coll.size());
        vertices.close();
        this.db.rollback();
        query = "select from Foo where name = 'Test' and SEARCH_CLASS(\"abc\")=true ";
        vertices = this.db.query(query, new Object[0]);
        Assertions.assertThat((Iterator)vertices).hasSize(2);
        Assert.assertEquals((long)2L, (long)index.getSize());
        vertices.close();
    }
}

