/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneSortTest
extends OLuceneBaseTest {
    @Before
    public void setUp() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]);
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE ", new Object[0]);
    }

    @Test
    public void shouldSortByReverseDocScore() throws Exception {
        this.db.command("create index Author.ft on Author (name,score) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OResultSet resultSet = this.db.query("SELECT score, name from Author where SEARCH_CLASS('*:* ', {sort: [ { reverse:true, type:'DOC' }]} ) = true ", new Object[0]);
        List scores = resultSet.stream().map(o -> (Integer)o.getProperty("score")).collect(Collectors.toList());
        Assertions.assertThat(scores).containsExactly((Object[])new Integer[]{4, 5, 10, 10, 7});
        resultSet.close();
    }

    @Test
    public void shouldSortByReverseScoreFieldValue() throws Exception {
        this.db.command("create index Author.ft on Author (score) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OResultSet resultSet = this.db.query("SELECT score, name from Author where SEARCH_CLASS('*:* ', {sort: [ { 'field': 'score', reverse:true, type:'INT' }]} ) = true ", new Object[0]);
        List scores = resultSet.stream().map(o -> (Integer)o.getProperty("score")).collect(Collectors.toList());
        Assertions.assertThat(scores).containsExactly((Object[])new Integer[]{10, 10, 7, 5, 4});
        resultSet.close();
    }

    @Test
    public void shouldSortByReverseNameValue() throws Exception {
        this.db.command("create index Author.ft on Author (name) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OResultSet resultSet = this.db.query("SELECT score, name from Author where SEARCH_CLASS('*:* ', {sort: [ {field: 'name', type:'STRING' , reverse:true}] } ) = true ", new Object[0]);
        List names = resultSet.stream().map(o -> (String)o.getProperty("name")).collect(Collectors.toList());
        Assertions.assertThat(names).containsExactly((Object[])new String[]{"Lennon McCartney", "Jack Mountain", "Grateful Dead", "Chuck Berry", "Bob Dylan"});
        resultSet.close();
    }

    @Test
    public void shouldSortByReverseNameValueWithTxRollback() throws Exception {
        this.db.command("create index Author.ft on Author (name) FULLTEXT ENGINE LUCENE ", new Object[0]);
        this.db.begin();
        OVertex artist = this.db.newVertex("Author");
        artist.setProperty("name", (Object)"Jimi Hendrix");
        this.db.save((Object)artist);
        OResultSet resultSet = this.db.query("SELECT score, name from Author where SEARCH_CLASS('*:* ', {sort: [ {field: 'name', type:'STRING' , reverse:true}] } ) = true ", new Object[0]);
        List names = resultSet.stream().map(o -> (String)o.getProperty("name")).collect(Collectors.toList());
        Assertions.assertThat(names).containsExactly((Object[])new String[]{"Lennon McCartney", "Jimi Hendrix", "Jack Mountain", "Grateful Dead", "Chuck Berry", "Bob Dylan"});
        this.db.rollback();
        resultSet.close();
        resultSet = this.db.query("SELECT score, name from Author where SEARCH_CLASS('*:* ', {sort: [ {field: 'name', type:'STRING' , reverse:true}] } ) = true ", new Object[0]);
        names = resultSet.stream().map(o -> (String)o.getProperty("name")).collect(Collectors.toList());
        Assertions.assertThat(names).containsExactly((Object[])new String[]{"Lennon McCartney", "Jack Mountain", "Grateful Dead", "Chuck Berry", "Bob Dylan"});
        resultSet.close();
    }

    @Test
    public void shouldSortByReverseScoreFieldValueAndThenReverseName() throws Exception {
        this.db.command("create index Author.ft on Author (name,score) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OResultSet resultSet = this.db.query("SELECT score, name from Author where SEARCH_CLASS('*:* ', {sort: [ { 'field': 'score', reverse:true, type:'INT' },{field: 'name', type:'STRING' , reverse:true}] } ) = true ", new Object[0]);
        List names = resultSet.stream().map(o -> "" + o.getProperty("score") + (String)o.getProperty("name")).collect(Collectors.toList());
        Assertions.assertThat(names).containsExactly((Object[])new String[]{"10Chuck Berry", "10Bob Dylan", "7Lennon McCartney", "5Grateful Dead", "4Jack Mountain"});
        resultSet.close();
    }
}

