/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneSkipLimitTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]);
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE", new Object[0]);
        this.db.command("create index Song.author on Song (author) FULLTEXT ENGINE LUCENE", new Object[0]);
    }

    @Test
    public void testContext() {
        OResultSet docs = this.db.query("select * from Song where search_fields(['title'],\"(title:man)\")=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(14);
        docs.close();
        docs = this.db.query("select * from Song where search_fields(['title'],\"(title:man)\")=true skip 10 limit 10", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(4);
        docs.close();
        docs = this.db.query("select * from Song where search_fields(['title'],\"(title:man)\")=true skip 14 limit 10", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(0);
        docs.close();
    }
}

