/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneSingleFieldEmbeddedTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]);
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE", new Object[0]);
        this.db.command("create index Song.author on Song (author) FULLTEXT ENGINE LUCENE", new Object[0]);
    }

    @Test
    public void loadAndTest() {
        OResultSet docs = this.db.query("select * from Song where search_fields(['title'],\"(title:mountain)\")=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(4);
        docs.close();
        docs = this.db.query("select * from Song where search_fields(['author'],\"(author:Fabbio)\")=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(87);
        docs.close();
        docs = this.db.query("select * from Song where search_fields(['title'],\"(title:mountain)\")=true  and search_fields(['author'],\"(author:Fabbio)\")=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
    }
}

