/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Date;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class OLuceneReuseTest
extends OLuceneBaseTest {
    @Test
    public void shouldUseTheRightIndex() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass cls = schema.createClass("Reuse");
        cls.createProperty("name", OType.STRING);
        cls.createProperty("date", OType.DATETIME);
        cls.createProperty("surname", OType.STRING);
        cls.createProperty("age", OType.LONG);
        this.db.command("create index Reuse.composite on Reuse (name,surname,date,age) UNIQUE", new Object[0]);
        this.db.command("create index Reuse.surname on Reuse (surname) FULLTEXT ENGINE LUCENE", new Object[0]);
        for (int i = 0; i < 10; ++i) {
            this.db.save((Object)new ODocument("Reuse").field("name", (Object)"John").field("date", (Object)new Date()).field("surname", (Object)"Reese").field("age", (Object)i));
        }
        OResultSet results = this.db.command("SELECT FROM Reuse WHERE name='John' and search_class('Reese') =true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(10);
        results = this.db.command("SELECT FROM Reuse WHERE search_class('Reese')=true  and name='John'", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(10);
    }

    @Test
    public void shouldUseTheRightLuceneIndex() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass cls = schema.createClass("Reuse");
        cls.createProperty("name", OType.STRING);
        cls.createProperty("date", OType.DATETIME);
        cls.createProperty("surname", OType.STRING);
        cls.createProperty("age", OType.LONG);
        this.db.command("create index Reuse.composite on Reuse (name,surname,date,age) UNIQUE", new Object[0]);
        this.db.command("create index Reuse.name_surname on Reuse (name,surname) FULLTEXT ENGINE LUCENE", new Object[0]);
        for (int i = 0; i < 10; ++i) {
            this.db.save((Object)new ODocument("Reuse").field("name", (Object)"John").field("date", (Object)new Date()).field("surname", (Object)"Reese").field("age", (Object)i));
        }
        this.db.save((Object)new ODocument("Reuse").field("name", (Object)"John").field("date", (Object)new Date()).field("surname", (Object)"Franklin").field("age", (Object)11));
        OResultSet results = this.db.command("SELECT FROM Reuse WHERE name='John' and search_class('Reese')=true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(10);
        results = this.db.command("SELECT FROM Reuse WHERE search_class('Reese')=true and name='John'", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(10);
        results = this.db.command("SELECT FROM Reuse WHERE name='John' AND search_class('surname:Franklin') =true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
    }
}

