/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneRangeTest
extends OLuceneBaseTest {
    @Before
    public void setUp() throws Exception {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass cls = schema.createClass("Person");
        cls.createProperty("name", OType.STRING);
        cls.createProperty("surname", OType.STRING);
        cls.createProperty("date", OType.DATETIME);
        cls.createProperty("age", OType.INTEGER);
        cls.createProperty("weight", OType.FLOAT);
        List<String> names = Arrays.asList("John", "Robert", "Jane", "andrew", "Scott", "luke", "Enriquez", "Luis", "Gabriel", "Sara");
        for (int i = 0; i < 10; ++i) {
            this.db.save((Object)new ODocument("Person").field("name", (Object)names.get(i)).field("surname", (Object)"Reese").field("date", (Object)(System.currentTimeMillis() - (long)(i * 3600 * 24 * 1000))).field("age", (Object)i).field("weight", (Object)Float.valueOf((float)i + 0.1f)));
        }
    }

    @Test
    public void shouldUseRangeQueryOnSingleFloatField() throws Exception {
        this.db.command("create index Person.weight on Person(weight) FULLTEXT ENGINE LUCENE", new Object[0]);
        Assertions.assertThat((long)this.db.getMetadata().getIndexManager().getIndex("Person.weight").getSize()).isEqualTo(11L);
        OResultSet results = this.db.command("SELECT FROM Person WHERE search_class('weight:[0.0 TO 1.1]') = true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(2);
        results = this.db.command("SELECT FROM Person WHERE search_class('weight:7.1') = true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
    }

    @Test
    public void shouldUseRangeQueryOnSingleIntegerField() throws Exception {
        this.db.command("create index Person.age on Person(age) FULLTEXT ENGINE LUCENE", new Object[0]);
        Assertions.assertThat((long)this.db.getMetadata().getIndexManager().getIndex("Person.age").getSize()).isEqualTo(11L);
        OResultSet results = this.db.command("SELECT FROM Person WHERE search_class('age:[5 TO 6]') = true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(2);
        results = this.db.command("SELECT FROM Person WHERE search_class('age:5') = true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
    }

    @Test
    public void shouldUseRangeQueryOnSingleDateField() throws Exception {
        this.db.commit();
        this.db.command("create index Person.date on Person(date) FULLTEXT ENGINE LUCENE", new Object[0]);
        this.db.commit();
        Assertions.assertThat((long)this.db.getMetadata().getIndexManager().getIndex("Person.date").getSize()).isEqualTo(11L);
        String today = DateTools.timeToString((long)System.currentTimeMillis(), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        String fiveDaysAgo = DateTools.timeToString((long)(System.currentTimeMillis() - 432000000L), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        OResultSet results = this.db.command("SELECT FROM Person WHERE search_class('date:[" + fiveDaysAgo + " TO " + today + "]')=true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(5);
    }

    @Test
    public void shouldUseRangeQueryMultipleField() throws Exception {
        this.db.command("create index Person.composite on Person(name,surname,date,age) FULLTEXT ENGINE LUCENE", new Object[0]);
        Assertions.assertThat((long)this.db.getMetadata().getIndexManager().getIndex("Person.composite").getSize()).isEqualTo(11L);
        this.db.commit();
        String today = DateTools.timeToString((long)System.currentTimeMillis(), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        String fiveDaysAgo = DateTools.timeToString((long)(System.currentTimeMillis() - 432000000L), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        OResultSet results = this.db.command("SELECT * FROM Person WHERE search_class('age:[5 TO 6] name:robert  ')=true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(3);
        results = this.db.command("SELECT FROM Person WHERE search_class('date:[" + fiveDaysAgo + " TO " + today + "]')=true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(5);
        results = this.db.command("SELECT FROM Person WHERE search_class('+age:[4 TO 7]  +date:[" + fiveDaysAgo + " TO " + today + "]')=true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(2);
    }

    @Test
    public void shouldUseRangeQueryMultipleFieldWithDirectIndexAccess() throws Exception {
        this.db.command("create index Person.composite on Person(name,surname,date,age) FULLTEXT ENGINE LUCENE", new Object[0]);
        Assertions.assertThat((long)this.db.getMetadata().getIndexManager().getIndex("Person.composite").getSize()).isEqualTo(11L);
        this.db.commit();
        String today = DateTools.timeToString((long)System.currentTimeMillis(), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        String fiveDaysAgo = DateTools.timeToString((long)(System.currentTimeMillis() - 432000000L), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        OResultSet results = this.db.query("SELECT * FROM index:Person.composite WHERE key ='name:luke  age:[5 TO 6]'", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(2);
        results.close();
        results = this.db.query("SELECT FROM index:Person.composite WHERE key = 'date:[" + fiveDaysAgo + " TO " + today + "]'", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(5);
        results.close();
        results = this.db.query("SELECT FROM index:Person.composite WHERE key = '+age:[4 TO 7]  +date:[" + fiveDaysAgo + " TO " + today + "]'", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(2);
        results.close();
        results = this.db.query("SELECT FROM index:Person.composite where key = '*:*'", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(11);
        results.close();
    }
}

