/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneQueryParserTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]);
    }

    @Test
    public void shouldSearchWithLeadingWildcard() {
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE metadata {\"allowLeadingWildcard\": true}", new Object[0]);
        OResultSet docs = this.db.query("select * from Song where search_class(\"(title:*tain)\") = true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(4);
        docs.close();
    }

    @Test
    public void shouldSearchWithLowercaseExpandedTerms() {
        this.db.command("create index Song.author on Song (author) FULLTEXT ENGINE LUCENE metadata {\"default\": \"" + KeywordAnalyzer.class.getCanonicalName() + "\", \"lowercaseExpandedTerms\": false}", new Object[0]);
        OResultSet docs = this.db.query("select * from Song where search_class('Hunter') =true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(97);
        docs.close();
        docs = this.db.query("select * from Song where search_class('HUNTER')=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(0);
        docs.close();
    }

    @Test
    public void shouldFailIfLeadingWild() {
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE metadata {\"allowLeadingWildcard\": true}", new Object[0]);
        OResultSet docs = this.db.query("select * from Song where search_class ('title:*tain')=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(4);
        docs.close();
    }

    @Test
    public void shouldUseBoostsFromQuery() throws Exception {
        this.db.command("create index Song.title_author on Song (title,author) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OResultSet rs = this.db.query("select * from Song where search_class ('(title:forever)^2 OR author:Boudleaux')=true", new Object[0]);
        List boostedDocs = rs.stream().map(r -> (String)r.getProperty("title")).collect(Collectors.toList());
        Assertions.assertThat(boostedDocs).hasSize(5);
        rs.close();
        Assertions.assertThat(boostedDocs).contains((Object[])new String[]{"THIS TIME FOREVER", "FOREVER YOUNG", "TOMORROW IS FOREVER", "STARS AND STRIPES FOREVER", "ALL I HAVE TO DO IS DREAM"});
        rs = this.db.query("select * from Song where search_class ('(title:forever) OR author:Boudleaux')=true", new Object[0]);
        List docs = rs.stream().map(r -> (String)r.getProperty("title")).collect(Collectors.toList());
        Assertions.assertThat(docs).hasSize(5);
        rs.close();
        Assertions.assertThat(docs).contains((Object[])new String[]{"THIS TIME FOREVER", "FOREVER YOUNG", "TOMORROW IS FOREVER", "ALL I HAVE TO DO IS DREAM", "STARS AND STRIPES FOREVER"});
    }

    @Test
    public void shouldUseBoostsFromMap() throws Exception {
        this.db.command("create index Song.title_author on Song (title,author) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OResultSet rs = this.db.query("select * from Song where search_class ('title:forever OR author:Boudleaux' , {'boost':{ 'title': 2  }  })=true", new Object[0]);
        List boostedDocs = rs.stream().map(r -> (String)r.getProperty("title")).collect(Collectors.toList());
        Assertions.assertThat(boostedDocs).hasSize(5);
        rs.close();
        Assertions.assertThat(boostedDocs).contains((Object[])new String[]{"THIS TIME FOREVER", "FOREVER YOUNG", "TOMORROW IS FOREVER", "STARS AND STRIPES FOREVER", "ALL I HAVE TO DO IS DREAM"});
        rs = this.db.query("select * from Song where search_class ('(title:forever) OR author:Boudleaux')=true", new Object[0]);
        List docs = rs.stream().map(r -> (String)r.getProperty("title")).collect(Collectors.toList());
        Assertions.assertThat(docs).hasSize(5);
        rs.close();
        Assertions.assertThat(docs).contains((Object[])new String[]{"THIS TIME FOREVER", "FOREVER YOUNG", "TOMORROW IS FOREVER", "ALL I HAVE TO DO IS DREAM", "STARS AND STRIPES FOREVER"});
    }

    @Test
    public void ahouldOverrideAnalyzer() throws Exception {
        this.db.command("create index Song.title_author on Song (title,author) FULLTEXT ENGINE LUCENE ", new Object[0]);
        OResultSet resultSet = this.db.query("select * from Song where search_class ('title:forever OR author:boudleaux' , {'customAnalysis': true,   \"query\": \"org.apache.lucene.analysis.core.KeywordAnalyzer\" } )=true", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(5);
        resultSet.close();
    }
}

