/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLucenePhraseQueriesTest
extends OLuceneBaseTest {
    @Before
    public void setUp() throws Exception {
        OClass type = this.db.createVertexClass("Role");
        type.createProperty("name", OType.STRING);
        this.db.command("create index Role.name on Role (name) FULLTEXT ENGINE LUCENE METADATA{\"name_index\": \"org.apache.lucene.analysis.standard.StandardAnalyzer\",\"name_index_stopwords\": \"[]\",\"name_query\": \"org.apache.lucene.analysis.standard.StandardAnalyzer\",\"name_query_stopwords\": \"[]\"} ", new Object[0]);
        OVertex role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"System IT Owner");
        this.db.save((Object)role);
        role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"System Business Owner");
        this.db.save((Object)role);
        role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"System Business SME");
        this.db.save((Object)role);
        role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"System Technical SME");
        this.db.save((Object)role);
        role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"System");
        this.db.save((Object)role);
        role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"boat");
        this.db.save((Object)role);
        role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"moat");
        this.db.save((Object)role);
    }

    @Test
    public void testPhraseQueries() throws Exception {
        OResultSet vertexes = this.db.command("select from Role where search_class(' \"Business Owner\" ')=true  ", new Object[0]);
        Assertions.assertThat((Iterator)vertexes).hasSize(1);
        vertexes = this.db.command("select from Role where search_class( ' \"Owner of Business\" ')=true  ", new Object[0]);
        Assertions.assertThat((Iterator)vertexes).hasSize(0);
        vertexes = this.db.command("select from Role where search_class(' \"System Owner\" '  )=true  ", new Object[0]);
        Assertions.assertThat((Iterator)vertexes).hasSize(0);
        vertexes = this.db.command("select from Role where search_class(' \"System SME\"~1 '  )=true  ", new Object[0]);
        Assertions.assertThat((Iterator)vertexes).hasSize(2);
        vertexes = this.db.command("select from Role where search_class(' \"System Business\"~1 '  )=true  ", new Object[0]);
        Assertions.assertThat((Iterator)vertexes).hasSize(2);
        vertexes = this.db.command("select from Role where search_class(' /[mb]oat/ '  )=true  ", new Object[0]);
        Assertions.assertThat((Iterator)vertexes).hasSize(2);
    }

    @Test
    public void testComplexPhraseQueries() throws Exception {
        OResultSet vertexes = this.db.command("select from Role where search_class(?)=true", new Object[]{"\"System SME\"~1"});
        Assertions.assertThat((Iterator)vertexes).allMatch(v -> ((String)v.getProperty("name")).contains("SME"));
        vertexes = this.db.command("select from Role where search_class(? )=true", new Object[]{"\"SME System\"~1"});
        Assertions.assertThat((Iterator)vertexes).isEmpty();
        vertexes = this.db.command("select from Role where search_class(?) =true", new Object[]{"\"Owner Of Business\""});
        vertexes.stream().forEach(v -> System.out.println("v = " + v.getProperty("name")));
        Assertions.assertThat((Iterator)vertexes).isEmpty();
        vertexes = this.db.command("select from Role where search_class(? )=true", new Object[]{"\"System Business SME\""});
        Assertions.assertThat((Iterator)vertexes).hasSize(1).allMatch(v -> ((String)v.getProperty("name")).equalsIgnoreCase("System Business SME"));
        vertexes = this.db.command("select from Role where search_class(? )=true", new Object[]{"\"System Owner\"~1 -IT"});
        Assertions.assertThat((Iterator)vertexes).hasSize(1).allMatch(v -> ((String)v.getProperty("name")).equalsIgnoreCase("System Business Owner"));
        vertexes = this.db.command("select from Role where search_class(? )=true", new Object[]{"+System +Own*~0.0 -IT"});
        Assertions.assertThat((Iterator)vertexes).hasSize(1).allMatch(v -> ((String)v.getProperty("name")).equalsIgnoreCase("System Business Owner"));
        vertexes = this.db.command("select from Role where search_class(? )=true", new Object[]{"\"System Owner\"~1 -Business"});
        Assertions.assertThat((Iterator)vertexes).hasSize(1).allMatch(v -> ((String)v.getProperty("name")).equalsIgnoreCase("System IT Owner"));
    }
}

