/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OLuceneNullTest
extends OLuceneBaseTest {
    @Before
    public void setUp() throws Exception {
        this.db.command("create class Test extends V", new Object[0]);
        this.db.command("create property Test.names EMBEDDEDLIST STRING", new Object[0]);
        this.db.command("create index Test.names on Test(names) FULLTEXT ENGINE LUCENE", new Object[0]);
    }

    @Test
    public void testNullChangeToNotNullWithLists() {
        this.db.begin();
        ODocument doc = new ODocument("Test");
        this.db.save((Object)doc);
        this.db.commit();
        this.db.begin();
        doc.field("names", (Object)new String[]{"foo"});
        this.db.save((Object)doc);
        this.db.commit();
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("Test.names");
        Assert.assertEquals((long)2L, (long)index.getSize());
    }

    @Test
    public void testNotNullChangeToNullWithLists() {
        ODocument doc = new ODocument("Test");
        this.db.begin();
        doc.field("names", (Object)new String[]{"foo"});
        this.db.save((Object)doc);
        this.db.commit();
        this.db.begin();
        doc.removeField("names");
        this.db.save((Object)doc);
        this.db.commit();
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("Test.names");
        Assert.assertEquals((long)1L, (long)index.getSize());
    }
}

