/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneMultiFieldTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        this.db.command("create index Song.title_author on Song (title,author) FULLTEXT ENGINE LUCENE METADATA {\"title_index\":\"" + EnglishAnalyzer.class.getName() + "\" , \"title_query\":\"" + EnglishAnalyzer.class.getName() + "\" , \"author_index\":\"" + StandardAnalyzer.class.getName() + "\"}", new Object[0]);
        ODocument index = this.db.getMetadata().getIndexManager().getIndex("Song.title_author").getMetadata();
        Assertions.assertThat((Object)index.field("author_index")).isEqualTo((Object)StandardAnalyzer.class.getName());
        Assertions.assertThat((Object)index.field("title_index")).isEqualTo((Object)EnglishAnalyzer.class.getName());
    }

    @Test
    public void testSelectSingleDocumentWithAndOperator() {
        OResultSet docs = this.db.query("select * from Song where  search_fields(['title','author'] ,'title:mountain AND author:Fabbio')=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
    }

    @Test
    public void testSelectMultipleDocumentsWithOrOperator() {
        OResultSet docs = this.db.query("select * from Song where  search_fields(['title','author'] ,'title:mountain OR author:Fabbio')=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(91);
        docs.close();
    }

    @Test
    public void testSelectOnTitleAndAuthorWithMatchOnTitle() {
        OResultSet docs = this.db.query("select * from  Song where search_fields(['title','author'] ,'title:mountain')=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(5);
        docs.close();
    }

    @Test
    public void testSelectOnTitleAndAuthorWithMatchOnAuthor() {
        OResultSet docs = this.db.query("select * from Song where search_class('author:fabbio')=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(87);
        docs.close();
        docs = this.db.query("select * from Song where search_class('fabbio')=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(87);
        docs.close();
    }

    @Test
    public void testSelectOnIndexWithIgnoreNullValuesToFalse() {
        String script = "create class Item;\ncreate property Item.title string;\ncreate property Item.summary string;\ncreate property Item.content string;\ncreate index Item.fulltext on Item(title, summary, content) FULLTEXT ENGINE LUCENE METADATA {'ignoreNullValues':false};\ninsert into Item set title = 'wrong', content = 'not me please';\ninsert into Item set title = 'test', content = 'this is a test';\n";
        this.db.execute("sql", script, new Object[0]).close();
        OResultSet docs = this.db.query("select * from Item where search_class('te*')=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
        docs = this.db.query("select * from Item where search_class('test')=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
        docs = this.db.query("select * from Item where search_class('title:test')=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
        docs = this.db.query(" SELECT expand(rid) FROM index:Item.fulltext where key = 'title:test'", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
    }
}

