/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneMixIndexTest
extends OLuceneBaseTest {
    @Before
    public void initLocal() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]);
        this.db.command("create index Song.author on Song (author) NOTUNIQUE", new Object[0]);
        this.db.command("create index Song.composite on Song (title,lyrics) FULLTEXT ENGINE LUCENE", new Object[0]);
    }

    @Test
    public void testMixQuery() {
        OResultSet docs = this.db.query("select * from Song where  author = 'Hornsby' and search_index('Song.composite','title:mountain')=true ", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
        docs = this.db.query("select * from Song where  author = 'Hornsby' and search_index('Song.composite','title:ballad')=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(0);
        docs.close();
    }

    @Test
    public void testMixCompositeQuery() {
        OResultSet docs = this.db.query("select * from Song where  author = 'Hornsby' and search_index('Song.composite','title:mountain')=true ", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
        docs = this.db.query("select * from Song where author = 'Hornsby' and search_index('Song.composite','lyrics:happy')=true ", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
    }
}

