/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;

public class OLuceneMiscTest
extends OLuceneBaseTest {
    @Test
    public void testDoubleLucene() {
        this.db.command("create class Test extends V", new Object[0]);
        this.db.command("create property Test.attr1 string", new Object[0]);
        this.db.command("create index Test.attr1 on Test(attr1) FULLTEXT ENGINE LUCENE", new Object[0]);
        this.db.command("create property Test.attr2 string", new Object[0]);
        this.db.command("create index Test.attr2 on Test(attr2) FULLTEXT ENGINE LUCENE", new Object[0]);
        this.db.command("insert into Test set attr1='foo', attr2='bar'", new Object[0]);
        this.db.command("insert into Test set attr1='bar', attr2='foo'", new Object[0]);
        OResultSet results = this.db.query("select from Test where search_index('Test.attr1',\"foo*\") =true OR search_index('Test.attr2', \"foo*\")=true  ", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(2);
        results.close();
        results = this.db.query("select from Test where SEARCH_FIELDS( ['attr1'], 'bar') = true OR SEARCH_FIELDS(['attr2'], 'bar*' )= true ", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(2);
        results.close();
        results = this.db.query("select from Test where SEARCH_FIELDS( ['attr1'], 'foo*') = true AND SEARCH_FIELDS(['attr2'], 'bar*') = true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
        results.close();
        results = this.db.query("select from Test where SEARCH_FIELDS( ['attr1'], 'bar*') = true AND SEARCH_FIELDS(['attr2'], 'foo*')= true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
        results.close();
    }

    @Test
    public void testSubLucene() {
        this.db.command("create class Person extends V", new Object[0]);
        this.db.command("create property Person.name string", new Object[0]);
        this.db.command("create index Person.name on Person(name) FULLTEXT ENGINE LUCENE", new Object[0]);
        this.db.command("insert into Person set name='Enrico', age=18", new Object[0]);
        String query = "select  from (select from Person where age = 18) where search_fields(['name'],'Enrico') = true";
        OResultSet results = this.db.query(query, new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
        results.close();
        query = "select  from (select name from Person where age = 18) where search_index('Person.name','Enrico') = true";
        results = this.db.query(query, new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
        results.close();
    }

    @Test
    public void testNamedParams() {
        this.db.command("create class Test extends V", new Object[0]);
        this.db.command("create property Test.attr1 string", new Object[0]);
        this.db.command("create index Test.attr1 on Test(attr1) FULLTEXT ENGINE LUCENE", new Object[0]);
        this.db.command("insert into Test set attr1='foo', attr2='bar'", new Object[0]);
        String query = "select from Test where  search_class( :name) =true";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "FOO or");
        OResultSet results = this.db.command(query, params);
        Assertions.assertThat((Iterator)results).hasSize(1);
    }

    @Test
    @Ignore
    public void dottedNotationTest() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass v = schema.getClass("V");
        OClass e = schema.getClass("E");
        OClass author = schema.createClass("Author", v);
        author.createProperty("name", OType.STRING);
        OClass song = schema.createClass("Song", v);
        song.createProperty("title", OType.STRING);
        OClass authorOf = schema.createClass("AuthorOf", e);
        authorOf.createProperty("in", OType.LINK, song);
        this.db.commit();
        this.db.command("create index AuthorOf.in on AuthorOf (in) NOTUNIQUE", new Object[0]);
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE", new Object[0]);
        OVertex authorVertex = this.db.newVertex("Author");
        authorVertex.setProperty("name", (Object)"Bob Dylan");
        this.db.save((Object)authorVertex);
        OVertex songVertex = this.db.newVertex("Song");
        songVertex.setProperty("title", (Object)"hurricane");
        this.db.save((Object)songVertex);
        OEdge edge = authorVertex.addEdge(songVertex, "AuthorOf");
        this.db.save((Object)edge);
        OResultSet results = this.db.query("select from AuthorOf", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
        results.close();
        results = this.db.query("select from AuthorOf where in.title lucene 'hurricane'", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
        results.close();
    }
}

