/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.functions.OLuceneFunctionsUtils;
import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneMetadataFieldsTest
extends OLuceneBaseTest {
    @Before
    public void setUp() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]);
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE ", new Object[0]);
    }

    @Test
    public void shouldFetchOnlyFromACluster() throws Exception {
        Assertions.assertThat((long)this.db.getMetadata().getIndexManager().getIndex("Song.title").getSize()).isEqualTo(586L);
        int cluster = this.db.getMetadata().getSchema().getClass("Song").getClusterIds()[1];
        this.db.commit();
        OResultSet results = this.db.query("SELECT FROM Song WHERE search_class('+_CLUSTER:" + cluster + "')=true ", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(73);
        results.close();
    }

    @Test
    public void shouldFetchByRid() throws Exception {
        String ridQuery = OLuceneFunctionsUtils.doubleEscape((String)"#26:4 #26:5");
        OResultSet results = this.db.query("SELECT FROM Song WHERE search_class('RID:(" + ridQuery + ") ')=true ", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(2);
        results.close();
    }
}

