/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OLuceneMassiveInsertDeleteTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass song = this.db.createVertexClass("City");
        song.createProperty("name", OType.STRING);
        this.db.command("create index City.name on City (name) FULLTEXT ENGINE LUCENE", new Object[0]);
    }

    @Test
    public void loadCloseDelete() {
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            OVertex city = this.db.newVertex("City");
            city.setProperty("name", (Object)("Rome " + i));
            this.db.save((Object)city);
        }
        String query = "select * from City where search_class('name:Rome')=true";
        OResultSet docs = this.db.query(query, new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(size);
        docs.close();
        this.db.close();
        this.db = this.pool.acquire();
        docs = this.db.query(query, new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(size);
        docs.close();
        this.db.command("delete vertex City", new Object[0]);
        docs = this.db.query(query, new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(0);
        docs.close();
        this.db.close();
        this.db = this.pool.acquire();
        docs = this.db.query(query, new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(0);
        docs.close();
        this.db.getMetadata().reload();
        OIndex idx = this.db.getMetadata().getSchema().getClass("City").getClassIndex("City.name");
        idx.flush();
        Assert.assertEquals((long)1L, (long)idx.getSize());
    }
}

