/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Iterator;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class OLuceneManualIndexTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        this.db.command("create index manual FULLTEXT ENGINE LUCENE STRING,STRING", new Object[0]);
        this.db.command("insert into index:manual (key,rid) values(['Enrico','London'],#5:0) ", new Object[0]);
        this.db.command("insert into index:manual (key,rid) values(['Luca','Rome'],#5:0) ", new Object[0]);
        this.db.command("insert into index:manual (key,rid) values(['Luigi','Rome'],#5:0) ", new Object[0]);
    }

    @Test
    public void shouldCreateManualIndexWithJavaApi() throws Exception {
        ODocument meta = new ODocument().field("analyzer", (Object)StandardAnalyzer.class.getName());
        OIndex index = this.db.getMetadata().getIndexManager().createIndex("apiManual", OClass.INDEX_TYPE.FULLTEXT.toString(), (OIndexDefinition)new OSimpleKeyIndexDefinition(1, new OType[]{OType.STRING, OType.STRING}), null, null, meta, "LUCENE");
        this.db.command("insert into index:apiManual (key,rid) values(['Enrico','London'],#5:0) ", new Object[0]);
        this.db.command("insert into index:apiManual (key,rid) values(['Luca','Rome'],#5:0) ", new Object[0]);
        this.db.command("insert into index:apiManual (key,rid) values(['Luigi','Rome'],#5:0) ", new Object[0]);
        Assert.assertEquals((long)index.getSize(), (long)4L);
        OResultSet docs = this.db.query("select from  index:apiManual  where  key = 'k0:Enrico'", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
        docs = this.db.command("select from index:apiManual where key = '(k0:Luca)'", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
        docs = this.db.command("select from index:apiManual where key ='(k1:Rome)'", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(2);
        docs.close();
        docs = this.db.command("select from index:apiManual where key ='(k1:London)'", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
    }

    @Test
    public void testManualIndex() {
        OIndex manual = this.db.getMetadata().getIndexManager().getIndex("manual");
        Assertions.assertThat((long)manual.getSize()).isEqualTo(4L);
        OResultSet docs = this.db.query("select from index:manual where key = 'Enrico'", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
    }

    @Test
    public void testManualIndexWitKeys() {
        OIndex manual = this.db.getMetadata().getIndexManager().getIndex("manual");
        Assert.assertEquals((long)manual.getSize(), (long)4L);
        OResultSet docs = this.db.query("select from index:manual where key = '(k0:Enrico)'", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
        docs = this.db.query("select from index:manual where key = '(k0:Luca)'", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
        docs = this.db.query("select from index:manual where key = '(k1:Rome)'", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(2);
        docs.close();
        docs = this.db.query("select from index:manual where key = '(k1:London)'", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
    }

    @Test
    @Ignore
    public void testManualIndexInsideTransaction() throws Exception {
        OIndex index = this.db.getMetadata().getIndexManager().createIndex("manualInTransaction", OClass.INDEX_TYPE.FULLTEXT.toString(), (OIndexDefinition)new OSimpleKeyIndexDefinition(1, new OType[]{OType.STRING}), null, null, null, "LUCENE");
        this.db.begin();
        ODocument document = (ODocument)this.db.newInstance();
        document.field("name", (Object)"Rob");
        this.db.save((Object)document);
        index.put((Object)"Rob", (OIdentifiable)document.getIdentity());
        index.flush();
        OResultSet docs = this.db.query("select from index:manualInTransaction where key = 'k0:rob'", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
        this.db.commit();
    }
}

