/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class OLuceneListIndexingTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass person = schema.createClass("Person");
        person.createProperty("name", OType.STRING);
        person.createProperty("tags", OType.EMBEDDEDLIST, OType.STRING);
        this.db.command("create index Person.name_tags on Person (name,tags) FULLTEXT ENGINE LUCENE", new Object[0]);
        OClass city = schema.createClass("City");
        city.createProperty("name", OType.STRING);
        city.createProperty("tags", OType.EMBEDDEDLIST, OType.STRING);
        this.db.command("create index City.tags on City (tags) FULLTEXT ENGINE LUCENE", new Object[0]);
    }

    @Test
    public void testIndexingList() throws Exception {
        OSchema schema = this.db.getMetadata().getSchema();
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        doc.field("tags", Arrays.asList("Beautiful", "Touristic", "Sunny"));
        this.db.save((Object)doc);
        OIndex tagsIndex = schema.getClass("City").getClassIndex("City.tags");
        Collection coll = (Collection)tagsIndex.get((Object)"Sunny");
        Assertions.assertThat((Iterable)coll).hasSize(1);
        doc = (ODocument)this.db.load((ORID)coll.iterator().next());
        Assertions.assertThat((String)((String)doc.field("name"))).isEqualTo((Object)"Rome");
        doc = new ODocument("City");
        doc.field("name", (Object)"London");
        doc.field("tags", Arrays.asList("Beautiful", "Touristic", "Sunny"));
        this.db.save((Object)doc);
        coll = (Collection)tagsIndex.get((Object)"Sunny");
        Assertions.assertThat((Iterable)coll).hasSize(2);
        List tags = (List)doc.field("tags");
        tags.remove("Sunny");
        tags.add("Rainy");
        this.db.save((Object)doc);
        coll = (Collection)tagsIndex.get((Object)"Rainy");
        Assertions.assertThat((Iterable)coll).hasSize(1);
        coll = (Collection)tagsIndex.get((Object)"Beautiful");
        Assertions.assertThat((Iterable)coll).hasSize(2);
        coll = (Collection)tagsIndex.get((Object)"Sunny");
        Assertions.assertThat((Iterable)coll).hasSize(1);
        OResultSet query = this.db.query("select from City where search_class('Beautiful') =true ", new Object[0]);
        Assertions.assertThat((Iterator)query).hasSize(2);
        query.close();
    }

    @Test
    @Ignore
    public void testCompositeIndexList() {
        OSchema schema = this.db.getMetadata().getSchema();
        ODocument doc = new ODocument("Person");
        doc.field("name", (Object)"Enrico");
        doc.field("tags", Arrays.asList("Funny", "Tall", "Geek"));
        this.db.save((Object)doc);
        OIndex idx = schema.getClass("Person").getClassIndex("Person.name_tags");
        Collection coll = (Collection)idx.get((Object)"Enrico");
        Assertions.assertThat((Iterable)coll).hasSize(3);
        doc = new ODocument("Person");
        doc.field("name", (Object)"Jared");
        doc.field("tags", Arrays.asList("Funny", "Tall"));
        this.db.save((Object)doc);
        coll = (Collection)idx.get((Object)"Jared");
        Assertions.assertThat((Iterable)coll).hasSize(2);
        List tags = (List)doc.field("tags");
        tags.remove("Funny");
        tags.add("Geek");
        this.db.save((Object)doc);
        coll = (Collection)idx.get((Object)"Funny");
        Assertions.assertThat((Iterable)coll).hasSize(1);
        coll = (Collection)idx.get((Object)"Geek");
        Assertions.assertThat((Iterable)coll).hasSize(2);
        OResultSet query = this.db.query("select from Person where search_class('name:Enrico') =true ", new Object[0]);
        Assertions.assertThat((Iterator)query).hasSize(1);
        query.close();
        query = this.db.query("select from (select from Person search_class('name:Enrico')=true)", new Object[0]);
        Assertions.assertThat((Iterator)query).hasSize(1);
        query.close();
        query = this.db.query("select from Person where search_class('Jared')=true", new Object[0]);
        Assertions.assertThat((Iterator)query).hasSize(1);
        query.close();
        query = this.db.query("select from Person where search_class('Funny') =true", new Object[0]);
        Assertions.assertThat((Iterator)query).hasSize(1);
        query.close();
        query = this.db.query("select from Person where search_class('Geek')=true", new Object[0]);
        Assertions.assertThat((Iterator)query).hasSize(2);
        query.close();
        query = this.db.query("select from Person where search_class('(name:Enrico AND tags:Geek) ')=true", new Object[0]);
        Assertions.assertThat((Iterator)query).hasSize(1);
        query.close();
    }
}

