/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OLuceneInsertUpdateTransactionTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass oClass = schema.createClass("City");
        oClass.createProperty("name", OType.STRING);
        this.db.command("create index City.name on City (name) FULLTEXT ENGINE LUCENE", new Object[0]);
    }

    @Test
    public void testInsertUpdateTransactionWithIndex() throws Exception {
        OSchema schema = this.db.getMetadata().getSchema();
        schema.reload();
        this.db.begin();
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        this.db.save((Object)doc);
        OIndex idx = schema.getClass("City").getClassIndex("City.name");
        Assert.assertNotNull((Object)idx);
        Collection coll = (Collection)idx.get((Object)"Rome");
        Assert.assertEquals((long)coll.size(), (long)1L);
        this.db.rollback();
        coll = (Collection)idx.get((Object)"Rome");
        Assert.assertEquals((long)coll.size(), (long)0L);
        this.db.begin();
        doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        this.db.save((Object)doc);
        OUser user = new OUser("test", "test");
        this.db.save((Object)user.getDocument());
        this.db.commit();
        coll = (Collection)idx.get((Object)"Rome");
        Assert.assertEquals((long)coll.size(), (long)1L);
    }
}

