/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OLuceneInsertUpdateTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass oClass = schema.createClass("City");
        oClass.createProperty("name", OType.STRING);
        this.db.command("create index City.name on City (name) FULLTEXT ENGINE LUCENE", new Object[0]);
    }

    @Test
    public void testInsertUpdateWithIndex() throws Exception {
        OSchema schema = this.db.getMetadata().getSchema();
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        this.db.save((Object)doc);
        OIndex idx = schema.getClass("City").getClassIndex("City.name");
        Collection coll = (Collection)idx.get((Object)"Rome");
        Assert.assertEquals((long)coll.size(), (long)1L);
        OIdentifiable next = (OIdentifiable)coll.iterator().next();
        doc = (ODocument)this.db.load((Object)next.getRecord());
        Assert.assertEquals((Object)doc.field("name"), (Object)"Rome");
        doc.field("name", (Object)"London");
        this.db.save((Object)doc);
        coll = (Collection)idx.get((Object)"Rome");
        Assert.assertEquals((long)coll.size(), (long)0L);
        coll = (Collection)idx.get((Object)"London");
        Assert.assertEquals((long)coll.size(), (long)1L);
        next = (OIdentifiable)coll.iterator().next();
        doc = (ODocument)this.db.load((Object)next.getRecord());
        Assert.assertEquals((Object)doc.field("name"), (Object)"London");
        doc.field("name", (Object)"Berlin");
        this.db.save((Object)doc);
        coll = (Collection)idx.get((Object)"Rome");
        Assert.assertEquals((long)coll.size(), (long)0L);
        coll = (Collection)idx.get((Object)"London");
        Assert.assertEquals((long)coll.size(), (long)0L);
        coll = (Collection)idx.get((Object)"Berlin");
        Assert.assertEquals((long)coll.size(), (long)1L);
    }
}

