/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OLuceneInsertReadMultiThreadTest
extends OLuceneBaseTest {
    private static final int THREADS = 10;
    private static final int RTHREADS = 10;
    private static final int CYCLE = 100;

    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass oClass = schema.createClass("City");
        oClass.createProperty("name", OType.STRING);
        this.db.command("create index City.name on City (name) FULLTEXT ENGINE LUCENE", new Object[0]);
    }

    @Test
    public void testConcurrentInsertWithIndex() throws Exception {
        List<CompletableFuture> futures = IntStream.range(0, 10).boxed().map(i -> CompletableFuture.runAsync(new LuceneInsert(this.pool, 100))).collect(Collectors.toList());
        futures.addAll(IntStream.range(0, 1).boxed().map(i -> CompletableFuture.runAsync(new LuceneReader(this.pool, 100))).collect(Collectors.toList()));
        futures.forEach(cf -> {
            Void cfr_ignored_0 = (Void)cf.join();
        });
        ODatabaseSession db1 = this.pool.acquire();
        db1.getMetadata().reload();
        OSchema schema = db1.getMetadata().getSchema();
        OIndex idx = schema.getClass("City").getClassIndex("City.name");
        Assert.assertEquals((long)idx.getSize(), (long)1001L);
    }

    public class LuceneReader
    implements Runnable {
        private final int cycle;
        private final ODatabasePool pool;

        public LuceneReader(ODatabasePool pool, int cycle) {
            this.pool = pool;
            this.cycle = cycle;
        }

        @Override
        public void run() {
            ODatabaseSession db = this.pool.acquire();
            db.activateOnCurrentThread();
            OSchema schema = db.getMetadata().getSchema();
            OIndex idx = schema.getClass("City").getClassIndex("City.name");
            for (int i = 0; i < this.cycle; ++i) {
                OResultSet resultSet = db.query("select from City where SEARCH_FIELDS(['name'], 'Rome') =true ", new Object[0]);
                if (resultSet.hasNext()) {
                    Assertions.assertThat((String)((String)resultSet.next().toElement().getProperty("name"))).isEqualToIgnoringCase((CharSequence)"rome");
                }
                resultSet.close();
            }
            db.close();
        }
    }

    public class LuceneInsert
    implements Runnable {
        private final ODatabasePool pool;
        private final int cycle;
        private final int commitBuf;

        public LuceneInsert(ODatabasePool pool, int cycle) {
            this.pool = pool;
            this.cycle = cycle;
            this.commitBuf = cycle / 10;
        }

        @Override
        public void run() {
            ODatabaseSession db = this.pool.acquire();
            db.activateOnCurrentThread();
            db.declareIntent((OIntent)new OIntentMassiveInsert());
            db.begin();
            for (int i = 0; i < this.cycle; ++i) {
                OElement doc = db.newElement("City");
                doc.setProperty("name", (Object)"Rome");
                db.save((Object)doc);
                if (i % this.commitBuf != 0) continue;
                db.commit();
                db.begin();
            }
            db.commit();
            db.close();
        }
    }
}

