/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneInsertDeleteTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass oClass = schema.createClass("City");
        oClass.createProperty("name", OType.STRING);
        this.db.command("create index City.name on City (name) FULLTEXT ENGINE LUCENE", new Object[0]);
    }

    @Test
    public void testInsertUpdateWithIndex() throws Exception {
        this.db.getMetadata().reload();
        OSchema schema = this.db.getMetadata().getSchema();
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        this.db.save((Object)doc);
        OIndex idx = schema.getClass("City").getClassIndex("City.name");
        Collection coll = (Collection)idx.get((Object)"Rome");
        Assertions.assertThat((Iterable)coll).hasSize(1);
        Assertions.assertThat((long)idx.getSize()).isEqualTo(2L);
        OIdentifiable next = (OIdentifiable)coll.iterator().next();
        doc = (ODocument)this.db.load((Object)next.getRecord());
        this.db.delete((Object)doc);
        coll = (Collection)idx.get((Object)"Rome");
        Assertions.assertThat((Iterable)coll).hasSize(0);
        Assertions.assertThat((long)idx.getSize()).isEqualTo(1L);
    }

    @Test
    public void testDeleteWithQueryOnClosedIndex() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]);
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE metadata {'closeAfterInterval':1000 , 'firstFlushAfter':1000 }", new Object[0]);
        OResultSet docs = this.db.query("select from Song where title lucene 'mountain'", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(4);
        TimeUnit.SECONDS.sleep(5L);
        docs.close();
        this.db.command("delete vertex from Song where title lucene 'mountain'", new Object[0]);
        docs = this.db.query("select from Song where  title lucene 'mountain'", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(0);
        docs.close();
    }
}

