/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.lucene.analyzer.OLucenePerFieldAnalyzerWrapper;
import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class OLuceneIndexVsLuceneTest
extends OLuceneBaseTest {
    private IndexWriter indexWriter;
    private OLucenePerFieldAnalyzerWrapper analyzer;

    @Before
    public void init() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]);
        OSchema schema = this.db.getMetadata().getSchema();
        OFileUtils.deleteRecursively((File)this.getPath().getAbsoluteFile());
        try {
            Directory dir = this.getDirectory();
            this.analyzer = new OLucenePerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer());
            this.analyzer.add("title", (Analyzer)new StandardAnalyzer()).add("Song.title", (Analyzer)new StandardAnalyzer());
            IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)this.analyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            this.indexWriter = new IndexWriter(dir, iwc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }

    private File getPath() {
        return new File("./target/databases/" + this.name.getMethodName());
    }

    protected Directory getDirectory() throws IOException {
        return NIOFSDirectory.open((Path)this.getPath().toPath());
    }

    @Test
    @Ignore
    public void testLuceneVsLucene() throws IOException, ParseException {
        for (ODocument oDocument : this.db.browseClass("Song")) {
            String title = (String)oDocument.field("title");
            if (title == null) continue;
            Document d = new Document();
            d.add((IndexableField)new TextField("title", title, Field.Store.YES));
            d.add((IndexableField)new TextField("Song.title", title, Field.Store.YES));
            this.indexWriter.addDocument((Iterable)d);
        }
        this.indexWriter.commit();
        this.indexWriter.close();
        DirectoryReader reader = DirectoryReader.open((Directory)this.getDirectory());
        Assertions.assertThat((int)reader.numDocs()).isEqualTo(Long.valueOf(this.db.countClass("Song")).intValue());
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        Query query = new MultiFieldQueryParser(new String[]{"title"}, (Analyzer)this.analyzer).parse("down the");
        TopDocs docs = searcher.search(query, Integer.MAX_VALUE);
        ScoreDoc[] hits = docs.scoreDocs;
        OResultSet resultSet = this.db.query("select *,$score from Song where search_class('down the')=true", new Object[0]);
        resultSet.stream().forEach(r -> {
            System.out.println("r = " + r);
            Assertions.assertThat((Object[])((Object[])r.toElement().getProperty("$score"))).isNotNull();
        });
        resultSet.close();
    }
}

