/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneGraphTxTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        OClass type = this.db.createVertexClass("City");
        type.createProperty("name", OType.STRING);
        this.db.command("create index City.name on City (name) FULLTEXT ENGINE LUCENE", new Object[0]);
    }

    @Test
    public void graphTxTest() throws Exception {
        OVertex v = this.db.newVertex("City");
        v.setProperty("name", (Object)"London");
        this.db.save((Object)v);
        OResultSet resultSet = this.db.command("select from City where search_class('London') =true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(1);
        v.setProperty("name", (Object)"Berlin");
        this.db.save((Object)v);
        resultSet = this.db.command("select from City where search_class('Berlin') =true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(1);
        resultSet = this.db.command("select from City where search_class('London') =true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(0);
        this.db.commit();
        resultSet = this.db.command("select from City where search_class('Berlin') =true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(1);
        resultSet = this.db.command("select from City where search_class('London') =true ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(0);
    }
}

