/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneGraphEmbeddedTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        OClass type = this.db.createVertexClass("City");
        type.createProperty("latitude", OType.DOUBLE);
        type.createProperty("longitude", OType.DOUBLE);
        type.createProperty("name", OType.STRING);
        this.db.command("create index City.name on City (name) FULLTEXT ENGINE LUCENE", new Object[0]);
        this.db.commit();
    }

    @Test
    public void embeddedTx() {
        this.db.begin();
        OVertex city = this.db.newVertex("City");
        city.setProperty("name", (Object)"London / a");
        this.db.save((Object)city);
        city = this.db.newVertex("City");
        city.setProperty("name", (Object)"Rome");
        this.db.save((Object)city);
        this.db.commit();
        this.db.begin();
        List docs = this.db.query((OQuery)new OSQLSynchQuery("SELECT from City where name = 'London / a' "), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(1);
        OResultSet resultSet = this.db.query("SELECT from City where name = 'London / a' ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(1);
        resultSet.close();
        resultSet = this.db.query("SELECT from City where name = 'Rome' ", new Object[0]);
        Assertions.assertThat((Iterator)resultSet).hasSize(1);
        resultSet.close();
    }

    @Test
    public void testGetVericesFilterClass() {
        OClass v = this.db.getClass("V");
        v.createProperty("name", OType.STRING);
        this.db.command("CREATE INDEX V.name ON V(name) NOTUNIQUE", new Object[0]);
        this.db.commit();
        OClass oneClass = this.db.createVertexClass("One");
        OClass twoClass = this.db.createVertexClass("Two");
        OVertex one = this.db.newVertex(oneClass);
        one.setProperty("name", (Object)"Same");
        this.db.save((Object)one);
        OVertex two = this.db.newVertex(twoClass);
        two.setProperty("name", (Object)"Same");
        this.db.save((Object)two);
        this.db.commit();
        OResultSet resultSet = this.db.query("SELECT from One where name = 'Same' ", new Object[0]);
        resultSet.getExecutionPlan().ifPresent(x -> System.out.println(x.prettyPrint(0, 2)));
        Assertions.assertThat((Iterator)resultSet).hasSize(1);
        resultSet.close();
    }
}

