/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneFreezeReleaseTest
extends OLuceneBaseTest {
    @Before
    public void setUp() throws Exception {
        this.dropDatabase();
        super.setupDatabase("ci");
    }

    @Test
    public void freezeReleaseTest() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass person = schema.createClass("Person");
        person.createProperty("name", OType.STRING);
        this.db.command("create index Person.name on Person (name) FULLTEXT ENGINE LUCENE", new Object[0]);
        this.db.save((Object)new ODocument("Person").field("name", (Object)"John"));
        OResultSet results = this.db.query("select from Person where search_class('John')=true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
        results.close();
        this.db.freeze();
        results = this.db.command("select from Person where search_class('John')=true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
        results.close();
        this.db.release();
        ODocument doc = (ODocument)this.db.newInstance("Person");
        doc.field("name", (Object)"John");
        this.db.save((Object)doc);
        results = this.db.query("select from Person where search_class('John')=true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(2);
        results.close();
    }

    @Test
    public void freezeReleaseMisUsageTest() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass person = schema.createClass("Person");
        person.createProperty("name", OType.STRING);
        this.db.command("create index Person.name on Person (name) FULLTEXT ENGINE LUCENE", new Object[0]);
        this.db.save((Object)new ODocument("Person").field("name", (Object)"John"));
        OResultSet results = this.db.command("select from Person where search_class('John')=true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
        results.close();
        this.db.freeze();
        this.db.freeze();
        results = this.db.command("select from Person where search_class('John')=true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
        results.close();
        this.db.release();
        this.db.release();
        this.db.save((Object)new ODocument("Person").field("name", (Object)"John"));
        results = this.db.command("select from Person where search_class('John')=true", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(2);
        results.close();
    }
}

