/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OLuceneExportImportTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass city = schema.createClass("City");
        city.createProperty("name", OType.STRING);
        this.db.command("create index City.name on City (name) FULLTEXT ENGINE LUCENE", new Object[0]);
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        this.db.save((Object)doc);
    }

    @Test
    public void testExportImport() throws Throwable {
        String file = "./target/exportTest.json";
        OResultSet query = this.db.query("select from City where search_class('Rome')=true", new Object[0]);
        Assertions.assertThat((Iterator)query).hasSize(1);
        query.close();
        try {
            new ODatabaseExport((ODatabaseDocumentInternal)this.db, file, s -> {}).exportDatabase();
            this.dropDatabase();
            this.setupDatabase();
            GZIPInputStream stream = new GZIPInputStream(new FileInputStream(file + ".gz"));
            new ODatabaseImport((ODatabaseDocumentInternal)this.db, (InputStream)stream, s -> {}).importDatabase();
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        Assertions.assertThat((long)this.db.countClass("City")).isEqualTo(1L);
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("City.name");
        Assertions.assertThat((String)index.getType()).isEqualTo((Object)OClass.INDEX_TYPE.FULLTEXT.toString());
        Assertions.assertThat((String)index.getAlgorithm()).isEqualTo((Object)"LUCENE");
        query = this.db.query("select from City where search_class('Rome')=true", new Object[0]);
        Assertions.assertThat((Iterator)query).hasSize(1);
        query.close();
    }
}

