/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.metadata.OMetadata;
import java.io.InputStream;
import java.util.logging.Level;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class OLuceneDropClusterTest
extends OLuceneBaseTest {
    @Test
    public void shouldRemoveCluster() throws Exception {
        OLogManager.instance().setConsoleLevel(Level.FINE.getName());
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]);
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE METADATA {\"default\":\"" + StandardAnalyzer.class.getName() + "\"}", new Object[0]);
        this.db.command("create index Song.author on Song (author) FULLTEXT ENGINE LUCENE METADATA {\"default\":\"" + StandardAnalyzer.class.getName() + "\"}", new Object[0]);
        OMetadata metadata = this.db.getMetadata();
        long initialIndexSize = metadata.getIndexManager().getIndex("Song.title").getSize();
        int[] clusterIds = metadata.getSchema().getClass("Song").getClusterIds();
        this.db.dropCluster(clusterIds[1], true);
        long afterDropIndexSize = metadata.getIndexManager().getIndex("Song.title").getSize();
        Assertions.assertThat((long)afterDropIndexSize).isLessThan(initialIndexSize);
    }
}

