/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneDocumentEmbeddedTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        OClass type = this.db.getMetadata().getSchema().createClass("City");
        type.createProperty("name", OType.STRING);
        this.db.command("create index City.name on City (name) FULLTEXT ENGINE LUCENE", new Object[0]);
    }

    @Test
    public void embeddedNoTx() {
        ODocument doc = new ODocument("City");
        doc.field("name", (Object)"London");
        this.db.save((Object)doc);
        doc = new ODocument("City");
        doc.field("name", (Object)"Rome");
        this.db.save((Object)doc);
        OResultSet results = this.db.command("select from City where SEARCH_FIELDS(['name'] ,'London') = true ", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
    }

    @Test
    public void embeddedTx() {
        ODocument doc = new ODocument("City");
        this.db.begin();
        doc.field("name", (Object)"Berlin");
        this.db.save((Object)doc);
        this.db.commit();
        OResultSet results = this.db.command("select from City where SEARCH_FIELDS(['name'] ,'Berlin')=true ", new Object[0]);
        Assertions.assertThat((Iterator)results).hasSize(1);
    }
}

