/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OLuceneCreateIndexTest
extends OLuceneBaseTest {
    @Before
    public void setUp() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.title on Song (title) fulltext ENGINE LUCENE METADATA {\"analyzer\":\"" + StandardAnalyzer.class.getName() + "\"}")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.author on Song (author) FULLTEXT ENGINE lucene METADATA {\"analyzer\":\"" + StandardAnalyzer.class.getName() + "\"}")).execute(new Object[0]);
        OVertex doc = this.db.newVertex("Song");
        doc.setProperty("title", (Object)"Local");
        doc.setProperty("author", (Object)"Local");
        this.db.save((Object)doc);
    }

    @Test
    public void testMetadata() {
        ODocument index = this.db.getMetadata().getIndexManager().getIndex("Song.title").getMetadata();
        Assert.assertEquals((Object)index.field("analyzer"), (Object)StandardAnalyzer.class.getName());
    }

    @Test
    public void testQueries() {
        OResultSet docs = this.db.query("select * from Song where search_fields(['title'],'mountain')=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(4);
        docs.close();
        docs = this.db.query("select * from Song where search_fields(['author'],'Fabbio')=true", new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(87);
        docs.close();
        String query = "select * from Song where search_fields(['title'],'mountain')=true AND search_fields(['author'],'Fabbio')=true";
        docs = this.db.query(query, new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
        query = "select * from Song where search_fields(['title'],'mountain')=true   and author = 'Fabbio'";
        docs = this.db.query(query, new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
    }

    @Test
    public void testQeuryOnAddedDocs() {
        String query = "select * from Song where search_fields(['title'],'local')=true ";
        OResultSet docs = this.db.query(query, new Object[0]);
        Assertions.assertThat((Iterator)docs).hasSize(1);
        docs.close();
    }
}

