/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneContextTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.execute("sql", this.getScriptFromStream(stream), new Object[0]);
        this.db.command("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE", new Object[0]);
    }

    @Test
    public void shouldReturnScore() {
        OResultSet docs = this.db.query("select *,$score from Song where search_index('Song.title', 'title:man')= true ", new Object[0]);
        List results = docs.stream().collect(Collectors.toList());
        Assertions.assertThat(results).hasSize(14);
        Float latestScore = Float.valueOf(100.0f);
        for (OResult doc : results) {
            Float score = (Float)doc.getProperty("$score");
            ((AbstractFloatAssert)Assertions.assertThat((Float)score).isNotNull()).isLessThanOrEqualTo((Comparable)latestScore);
            latestScore = score;
        }
        docs.close();
    }

    @Test
    public void shouldReturnTotalHits() throws Exception {
        OResultSet docs = this.db.query("select *,$totalHits,$Song_title_totalHits from Song where search_class('title:man')= true  limit 1", new Object[0]);
        List results = docs.stream().collect(Collectors.toList());
        Assertions.assertThat(results).hasSize(1);
        OResult doc = (OResult)results.get(0);
        System.out.println("doc.toElement().toJSON() = " + doc.toElement().toJSON());
        Assertions.assertThat((Long)((Long)doc.getProperty("$totalHits"))).isEqualTo(14L);
        Assertions.assertThat((Long)((Long)doc.getProperty("$Song_title_totalHits"))).isEqualTo(14L);
        docs.close();
    }
}

