/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.lucene.tests.OLuceneBaseTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class OLuceneBooleanIndexTest
extends OLuceneBaseTest {
    @Before
    public void init() {
        OClass personClass = this.db.createVertexClass("Person");
        personClass.createProperty("isDeleted", OType.BOOLEAN);
        this.db.command((OCommandRequest)new OCommandSQL("create index Person.isDeleted on Person (isDeleted) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        for (int i = 0; i < 1000; ++i) {
            OVertex person = this.db.newVertex("Person");
            person.setProperty("isDeleted", (Object)(i % 2 == 0 ? 1 : 0));
            this.db.save((Object)person);
        }
    }

    @Test
    public void shouldQueryBooleanField() {
        OResultSet docs = this.db.query("select from Person where search_class('false') = true", new Object[0]);
        List results = docs.stream().collect(Collectors.toList());
        Assertions.assertThat(results).hasSize(500);
        Assertions.assertThat((Boolean)((Boolean)((OResult)results.get(0)).getProperty("isDeleted"))).isFalse();
        docs.close();
        docs = this.db.query("select from Person where search_class('true') = true", new Object[0]);
        results = docs.stream().collect(Collectors.toList());
        Assertions.assertThat(results).hasSize(500);
        Assertions.assertThat((Boolean)((Boolean)((OResult)results.get(0)).getProperty("isDeleted"))).isTrue();
        docs.close();
    }
}

