/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tests;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import java.io.IOException;
import java.io.InputStream;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class OLuceneBaseTest {
    @Rule
    public TestName name = new TestName();
    protected ODatabaseDocument db;
    protected OrientDB orient;
    protected ODatabasePool pool;

    @Before
    public void setupDatabase() {
        String config = System.getProperty("orientdb.test.env", "memory");
        this.setupDatabase(config);
    }

    protected void setupDatabase(String config) {
        OrientDBConfig cfg = OrientDBConfig.builder().addAttribute(ODatabase.ATTRIBUTES.MINIMUMCLUSTERS, (Object)8).build();
        if ("ci".equals(config) || "release".equals(config)) {
            this.orient = new OrientDB("embedded:./target/databases/", cfg);
            if (this.orient.exists(this.name.getMethodName())) {
                this.orient.drop(this.name.getMethodName());
            }
            this.orient.create(this.name.getMethodName(), ODatabaseType.PLOCAL);
        } else {
            this.orient = new OrientDB("embedded:", cfg);
            if (this.orient.exists(this.name.getMethodName())) {
                this.orient.drop(this.name.getMethodName());
            }
            this.orient.create(this.name.getMethodName(), ODatabaseType.MEMORY);
        }
        this.pool = new ODatabasePool(this.orient, this.name.getMethodName(), "admin", "admin");
        this.db = this.pool.acquire();
    }

    @After
    public void dropDatabase() {
        this.db.activateOnCurrentThread();
        this.db.close();
        this.pool.close();
        this.orient.drop(this.name.getMethodName());
        this.orient.close();
    }

    protected String getScriptFromStream(InputStream in) {
        try {
            return OIOUtils.readStreamAsString((InputStream)in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

