/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneTransactionQueryTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OClass c1 = this.db.createVertexClass("C1");
        c1.createProperty("p1", OType.STRING);
        c1.createIndex("C1.p1", "FULLTEXT", null, null, "LUCENE", new String[]{"p1"});
    }

    @Test
    public void testRollback() {
        ODocument doc = new ODocument("c1");
        doc.field("p1", (Object)"abc");
        this.db.begin();
        this.db.save((ORecord)doc);
        String query = "select from C1 where p1 lucene \"abc\" ";
        List vertices = (List)ODatabaseRecordThreadLocal.instance().get().command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assert.assertEquals((long)vertices.size(), (long)1L);
        this.db.rollback();
        query = "select from C1 where p1 lucene \"abc\" ";
        vertices = (List)ODatabaseRecordThreadLocal.instance().get().command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assert.assertEquals((long)vertices.size(), (long)0L);
    }

    @Test
    public void txRemoveTest() {
        this.db.begin();
        ODocument doc = new ODocument("c1");
        doc.field("p1", (Object)"abc");
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("C1.p1");
        this.db.save((ORecord)doc);
        String query = "select from C1 where p1 lucene \"abc\" ";
        List vertices = (List)ODatabaseRecordThreadLocal.instance().get().command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assert.assertEquals((long)1L, (long)vertices.size());
        Assert.assertEquals((long)2L, (long)index.getSize());
        this.db.commit();
        query = "select from C1 where p1 lucene \"abc\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assert.assertEquals((long)1L, (long)vertices.size());
        Assert.assertEquals((long)2L, (long)index.getSize());
        this.db.begin();
        doc = new ODocument("c1");
        doc.field("p1", (Object)"abc");
        this.db.delete((ORecord)vertices.get(0));
        query = "select from C1 where p1 lucene \"abc\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Collection coll = (Collection)index.get((Object)"abc");
        Assert.assertEquals((long)vertices.size(), (long)0L);
        Assert.assertEquals((long)coll.size(), (long)0L);
        Iterator iterator = coll.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        Assert.assertEquals((long)0L, (long)i);
        Assert.assertEquals((long)1L, (long)index.getSize());
        this.db.rollback();
        query = "select from C1 where p1 lucene \"abc\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assert.assertEquals((long)1L, (long)vertices.size());
        Assert.assertEquals((long)2L, (long)index.getSize());
    }

    @Test
    public void txUpdateTest() {
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("C1.p1");
        OClass c1 = this.db.getMetadata().getSchema().getClass("C1");
        try {
            c1.truncate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)index.getSize(), (long)0L);
        this.db.begin();
        ODocument doc = new ODocument("c1");
        doc.field("p1", (Object)"update");
        this.db.save((ORecord)doc);
        String query = "select from C1 where p1 lucene \"update\" ";
        List vertices = (List)ODatabaseRecordThreadLocal.instance().get().command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assert.assertEquals((long)vertices.size(), (long)1L);
        Assert.assertEquals((long)index.getSize(), (long)1L);
        this.db.commit();
        query = "select from C1 where p1 lucene \"update\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Collection coll = (Collection)index.get((Object)"update");
        Assert.assertEquals((long)vertices.size(), (long)1L);
        Assert.assertEquals((long)coll.size(), (long)1L);
        Assert.assertEquals((long)index.getSize(), (long)1L);
        this.db.begin();
        ODocument record = (ODocument)vertices.get(0);
        record.field("p1", (Object)"removed");
        this.db.save((ORecord)record);
        query = "select from C1 where p1 lucene \"update\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        coll = (Collection)index.get((Object)"update");
        Assert.assertEquals((long)vertices.size(), (long)0L);
        Assert.assertEquals((long)coll.size(), (long)0L);
        Iterator iterator = coll.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        Assert.assertEquals((long)i, (long)0L);
        Assert.assertEquals((long)index.getSize(), (long)1L);
        query = "select from C1 where p1 lucene \"removed\"";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        coll = (Collection)index.get((Object)"removed");
        Assert.assertEquals((long)vertices.size(), (long)1L);
        Assert.assertEquals((long)coll.size(), (long)1L);
        this.db.rollback();
        query = "select from C1 where p1 lucene \"update\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assert.assertEquals((long)vertices.size(), (long)1L);
        Assert.assertEquals((long)index.getSize(), (long)1L);
    }

    @Test
    public void txUpdateTestComplex() {
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("C1.p1");
        OClass c1 = this.db.getMetadata().getSchema().getClass("C1");
        try {
            c1.truncate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)index.getSize(), (long)0L);
        this.db.begin();
        ODocument doc = new ODocument("c1");
        doc.field("p1", (Object)"abc");
        ODocument doc1 = new ODocument("c1");
        doc1.field("p1", (Object)"abc");
        this.db.save((ORecord)doc1);
        this.db.save((ORecord)doc);
        this.db.commit();
        this.db.begin();
        doc.field("p1", (Object)"removed");
        this.db.save((ORecord)doc);
        String query = "select from C1 where p1 lucene \"abc\"";
        List vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Collection coll = (Collection)index.get((Object)"abc");
        Assert.assertEquals((long)vertices.size(), (long)1L);
        Assert.assertEquals((long)coll.size(), (long)1L);
        Iterator iterator = coll.iterator();
        int i = 0;
        ORecordId rid = null;
        while (iterator.hasNext()) {
            rid = (ORecordId)iterator.next();
            ++i;
        }
        Assert.assertEquals((long)i, (long)1L);
        Assert.assertEquals((Object)doc1.getIdentity().toString(), (Object)rid.getIdentity().toString());
        Assert.assertEquals((long)index.getSize(), (long)2L);
        query = "select from C1 where p1 lucene \"removed\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        coll = (Collection)index.get((Object)"removed");
        Assert.assertEquals((long)vertices.size(), (long)1L);
        Assert.assertEquals((long)coll.size(), (long)1L);
        this.db.rollback();
        query = "select from C1 where p1 lucene \"abc\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assert.assertEquals((long)vertices.size(), (long)2L);
        Assert.assertEquals((long)index.getSize(), (long)2L);
    }
}

