/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class LuceneTransactionEmbeddedQueryTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollback() {
        ODatabaseDocumentTx db = new ODatabaseDocumentTx("memory:updateTxTest");
        db.create();
        this.createSchema(db);
        try {
            ODocument doc = new ODocument("c1");
            doc.field("p1", (Object)new String[]{"abc"});
            db.begin();
            db.save((ORecord)doc);
            String query = "select from C1 where p1 lucene \"abc\" ";
            List vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            Assert.assertEquals((long)vertices.size(), (long)1L);
            db.rollback();
            query = "select from C1 where p1 lucene \"abc\" ";
            vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            Assert.assertEquals((long)vertices.size(), (long)0L);
        }
        finally {
            db.drop();
        }
    }

    protected void createSchema(ODatabaseDocumentTx db) {
        OClass c1 = db.createVertexClass("C1");
        c1.createProperty("p1", OType.EMBEDDEDLIST, OType.STRING);
        c1.createIndex("C1.p1", "FULLTEXT", null, null, "LUCENE", new String[]{"p1"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void txRemoveTest() {
        ODatabaseDocumentTx db = new ODatabaseDocumentTx("memory:updateTxTest");
        db.create();
        this.createSchema(db);
        try {
            db.begin();
            ODocument doc = new ODocument("c1");
            doc.field("p1", (Object)new String[]{"abc"});
            OIndex index = db.getMetadata().getIndexManager().getIndex("C1.p1");
            db.save((ORecord)doc);
            String query = "select from C1 where p1 lucene \"abc\" ";
            List vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            Assert.assertEquals((long)1L, (long)vertices.size());
            Assert.assertEquals((long)2L, (long)index.getSize());
            db.commit();
            query = "select from C1 where p1 lucene \"abc\" ";
            vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            Assert.assertEquals((long)1L, (long)vertices.size());
            Assert.assertEquals((long)2L, (long)index.getSize());
            db.begin();
            db.delete((ORecord)vertices.get(0));
            query = "select from C1 where p1 lucene \"abc\" ";
            vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            Collection coll = (Collection)index.get((Object)"abc");
            Assert.assertEquals((long)vertices.size(), (long)0L);
            Assert.assertEquals((long)coll.size(), (long)0L);
            Iterator iterator = coll.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++i;
            }
            Assert.assertEquals((long)0L, (long)i);
            Assert.assertEquals((long)1L, (long)index.getSize());
            db.rollback();
            query = "select from C1 where p1 lucene \"abc\" ";
            vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            Assert.assertEquals((long)1L, (long)vertices.size());
            Assert.assertEquals((long)2L, (long)index.getSize());
        }
        finally {
            db.drop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void txUpdateTest() {
        ODatabaseDocumentTx db = new ODatabaseDocumentTx("memory:updateTxTest");
        db.create();
        this.createSchema(db);
        try {
            OIndex index = db.getMetadata().getIndexManager().getIndex("C1.p1");
            Assert.assertEquals((long)1L, (long)index.getSize());
            db.begin();
            ODocument doc = new ODocument("c1");
            doc.field("p1", (Object)new String[]{"update removed", "update fixed"});
            db.save((ORecord)doc);
            String query = "select from C1 where p1 lucene \"update\" ";
            List vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            Assert.assertEquals((long)vertices.size(), (long)1L);
            Assert.assertEquals((long)3L, (long)index.getSize());
            db.commit();
            query = "select from C1 where p1 lucene \"update\" ";
            vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            Collection coll = (Collection)index.get((Object)"update");
            Assert.assertEquals((long)1L, (long)vertices.size());
            Assert.assertEquals((long)2L, (long)coll.size());
            Assert.assertEquals((long)3L, (long)index.getSize());
            db.begin();
            ODocument record = (ODocument)vertices.get(0);
            Collection p1 = (Collection)record.field("p1");
            p1.remove("update removed");
            db.save((ORecord)record);
            query = "select from C1 where p1 lucene \"update\" ";
            vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            coll = (Collection)index.get((Object)"update");
            Assert.assertEquals((long)vertices.size(), (long)1L);
            Assert.assertEquals((long)coll.size(), (long)1L);
            Iterator iterator = coll.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++i;
            }
            Assert.assertEquals((long)i, (long)1L);
            Assert.assertEquals((long)2L, (long)index.getSize());
            query = "select from C1 where p1 lucene \"update\"";
            vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            coll = (Collection)index.get((Object)"update");
            Assert.assertEquals((long)coll.size(), (long)1L);
            Assert.assertEquals((long)vertices.size(), (long)1L);
            db.rollback();
            query = "select from C1 where p1 lucene \"update\" ";
            vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            Assert.assertEquals((long)1L, (long)vertices.size());
            Assert.assertEquals((long)3L, (long)index.getSize());
        }
        finally {
            db.drop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void txUpdateTestComplex() {
        ODatabaseDocumentTx db = new ODatabaseDocumentTx("memory:updateTxTest");
        db.create();
        this.createSchema(db);
        try {
            OIndex index = db.getMetadata().getIndexManager().getIndex("C1.p1");
            Assert.assertEquals((long)1L, (long)index.getSize());
            db.begin();
            ODocument doc = new ODocument("c1");
            doc.field("p1", (Object)new String[]{"abc"});
            ODocument doc1 = new ODocument("c1");
            doc1.field("p1", (Object)new String[]{"abc"});
            db.save((ORecord)doc1);
            db.save((ORecord)doc);
            db.commit();
            db.begin();
            doc.field("p1", (Object)new String[]{"removed"});
            db.save((ORecord)doc);
            String query = "select from C1 where p1 lucene \"abc\"";
            List vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            Collection coll = (Collection)index.get((Object)"abc");
            Assert.assertEquals((long)1L, (long)vertices.size());
            Assert.assertEquals((long)1L, (long)coll.size());
            Iterator iterator = coll.iterator();
            int i = 0;
            ORecordId rid = null;
            while (iterator.hasNext()) {
                rid = (ORecordId)iterator.next();
                ++i;
            }
            Assert.assertEquals((long)1L, (long)i);
            Assert.assertEquals((Object)doc1.getIdentity().toString(), (Object)rid.getIdentity().toString());
            Assert.assertEquals((long)3L, (long)index.getSize());
            query = "select from C1 where p1 lucene \"removed\" ";
            vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            coll = (Collection)index.get((Object)"removed");
            Assert.assertEquals((long)1L, (long)vertices.size());
            Assert.assertEquals((long)1L, (long)coll.size());
            db.rollback();
            query = "select from C1 where p1 lucene \"abc\" ";
            vertices = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
            Assert.assertEquals((long)2L, (long)vertices.size());
            Assert.assertEquals((long)3L, (long)index.getSize());
        }
        finally {
            db.drop();
        }
    }
}

