/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneTransactionCompositeQueryTest
extends BaseLuceneTest {
    @Before
    public void init() {
        OClass c1 = this.db.createVertexClass("Foo");
        c1.createProperty("name", OType.STRING);
        c1.createProperty("bar", OType.STRING);
        c1.createIndex("Foo.bar", "FULLTEXT", null, null, "LUCENE", new String[]{"bar"});
        c1.createIndex("Foo.name", "NOTUNIQUE", null, null, "SBTREE", new String[]{"name"});
    }

    @Test
    public void testRollback() {
        ODocument doc = new ODocument("Foo");
        doc.field("name", (Object)"Test");
        doc.field("bar", (Object)"abc");
        this.db.begin();
        this.db.save((ORecord)doc);
        String query = "select from Foo where name = 'Test' and bar lucene \"abc\" ";
        List vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assertions.assertThat((List)vertices).hasSize(1);
        this.db.rollback();
        query = "select from Foo where name = 'Test' and bar lucene \"abc\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assertions.assertThat((List)vertices).hasSize(0);
    }

    @Test
    public void txRemoveTest() {
        this.db.begin();
        ODocument doc = new ODocument("Foo");
        doc.field("name", (Object)"Test");
        doc.field("bar", (Object)"abc");
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("Foo.bar");
        this.db.save((ORecord)doc);
        this.db.commit();
        this.db.begin();
        this.db.delete((ORecord)doc);
        String query = "select from Foo where name = 'Test' and bar lucene \"abc\" ";
        List vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Collection coll = (Collection)index.get((Object)"abc");
        Assertions.assertThat((List)vertices).hasSize(0);
        Assert.assertEquals((long)coll.size(), (long)0L);
        Assert.assertEquals((long)1L, (long)index.getSize());
        this.db.rollback();
        query = "select from Foo where name = 'Test' and bar lucene \"abc\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assertions.assertThat((List)vertices).hasSize(1);
        Assert.assertEquals((long)2L, (long)index.getSize());
    }

    @Test
    public void txUpdateTest() {
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("Foo.bar");
        OClass c1 = this.db.getMetadata().getSchema().getClass("Foo");
        try {
            c1.truncate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)index.getSize(), (long)0L);
        this.db.begin();
        ODocument doc = new ODocument("Foo");
        doc.field("name", (Object)"Test");
        doc.field("bar", (Object)"abc");
        this.db.save((ORecord)doc);
        this.db.commit();
        this.db.begin();
        doc.field("bar", (Object)"removed");
        this.db.save((ORecord)doc);
        String query = "select from Foo where name = 'Test' and bar lucene \"abc\" ";
        List vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Collection coll = (Collection)index.get((Object)"abc");
        Assertions.assertThat((List)vertices).hasSize(0);
        Assert.assertEquals((long)coll.size(), (long)0L);
        Iterator iterator = coll.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        Assert.assertEquals((long)i, (long)0L);
        Assert.assertEquals((long)index.getSize(), (long)1L);
        query = "select from Foo where name = 'Test' and bar lucene \"removed\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        coll = (Collection)index.get((Object)"removed");
        Assertions.assertThat((List)vertices).hasSize(1);
        Assert.assertEquals((long)coll.size(), (long)1L);
        this.db.rollback();
        query = "select from Foo where name = 'Test' and bar lucene \"abc\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assertions.assertThat((List)vertices).hasSize(1);
        Assert.assertEquals((long)index.getSize(), (long)1L);
    }

    @Test
    public void txUpdateTestComplex() {
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("Foo.bar");
        OClass c1 = this.db.getMetadata().getSchema().getClass("Foo");
        try {
            c1.truncate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)index.getSize(), (long)0L);
        this.db.begin();
        ODocument doc = new ODocument("Foo");
        doc.field("name", (Object)"Test");
        doc.field("bar", (Object)"abc");
        ODocument doc1 = new ODocument("Foo");
        doc1.field("name", (Object)"Test");
        doc1.field("bar", (Object)"abc");
        this.db.save((ORecord)doc1);
        this.db.save((ORecord)doc);
        this.db.commit();
        this.db.begin();
        doc.field("bar", (Object)"removed");
        this.db.save((ORecord)doc);
        String query = "select from Foo where name = 'Test' and bar lucene \"abc\" ";
        List vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Collection coll = (Collection)index.get((Object)"abc");
        Assertions.assertThat((List)vertices).hasSize(1);
        Assert.assertEquals((long)1L, (long)coll.size());
        Iterator iterator = coll.iterator();
        int i = 0;
        ORecordId rid = null;
        while (iterator.hasNext()) {
            rid = (ORecordId)iterator.next();
            ++i;
        }
        Assert.assertEquals((long)1L, (long)i);
        Assert.assertEquals((Object)rid.getIdentity().toString(), (Object)doc1.getIdentity().toString());
        Assert.assertEquals((long)2L, (long)index.getSize());
        query = "select from Foo where name = 'Test' and bar lucene \"removed\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        coll = (Collection)index.get((Object)"removed");
        Assertions.assertThat((List)vertices).hasSize(1);
        Assert.assertEquals((long)1L, (long)coll.size());
        this.db.rollback();
        query = "select from Foo where name = 'Test' and bar lucene \"abc\" ";
        vertices = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[0]);
        Assertions.assertThat((List)vertices).hasSize(2);
        Assert.assertEquals((long)2L, (long)index.getSize());
    }
}

