/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneSkipLimitTest
extends BaseLuceneTest {
    @Test
    public void testContext() {
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where [title] LUCENE \"(title:man)\""), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)14L);
        ODocument doc = (ODocument)docs.get(9);
        docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where [title] LUCENE \"(title:man)\" skip 10 limit 10"), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)4L);
        Assert.assertEquals((Object)docs.contains(doc), (Object)false);
        docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where [title] LUCENE \"(title:man)\" skip 14 limit 10"), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)0L);
    }

    @Before
    public void init() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.author on Song (author) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
    }
}

