/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class LuceneReuseTest
extends BaseLuceneTest {
    @Test
    public void shouldUseTheRightIndex() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass cls = schema.createClass("Reuse");
        cls.createProperty("name", OType.STRING);
        cls.createProperty("date", OType.DATETIME);
        cls.createProperty("surname", OType.STRING);
        cls.createProperty("age", OType.LONG);
        this.db.command((OCommandRequest)new OCommandSQL("create index Reuse.composite on Reuse (name,surname,date,age) UNIQUE")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Reuse.surname on Reuse (surname) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        for (int i = 0; i < 10; ++i) {
            this.db.save((ORecord)new ODocument("Reuse").field("name", (Object)"John").field("date", (Object)new Date()).field("surname", (Object)"Reese").field("age", (Object)i));
        }
        Collection results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT FROM Reuse WHERE name='John' and surname LUCENE 'Reese'")).execute(new Object[0]);
        Assert.assertEquals((long)10L, (long)results.size());
        results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT FROM Reuse WHERE surname LUCENE 'Reese' and name='John'")).execute(new Object[0]);
        Assert.assertEquals((long)10L, (long)results.size());
    }

    @Test
    public void shouldUseTheRightLuceneIndex() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass cls = schema.createClass("Reuse");
        cls.createProperty("name", OType.STRING);
        cls.createProperty("date", OType.DATETIME);
        cls.createProperty("surname", OType.STRING);
        cls.createProperty("age", OType.LONG);
        this.db.command((OCommandRequest)new OCommandSQL("create index Reuse.composite on Reuse (name,surname,date,age) UNIQUE")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Reuse.name_surname on Reuse (name,surname) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        for (int i = 0; i < 10; ++i) {
            this.db.save((ORecord)new ODocument("Reuse").field("name", (Object)"John").field("date", (Object)new Date()).field("surname", (Object)"Reese").field("age", (Object)i));
        }
        this.db.save((ORecord)new ODocument("Reuse").field("name", (Object)"John").field("date", (Object)new Date()).field("surname", (Object)"Franklin").field("age", (Object)11));
        Collection results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT FROM Reuse WHERE name='John' and [name,surname] LUCENE 'Reese'")).execute(new Object[0]);
        Assert.assertEquals((long)10L, (long)results.size());
        results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT FROM Reuse WHERE [name,surname] LUCENE 'Reese' and name='John'")).execute(new Object[0]);
        Assert.assertEquals((long)10L, (long)results.size());
        results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT FROM Reuse WHERE name='John' and [name,surname] LUCENE '(surname:Franklin)'")).execute(new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
    }
}

