/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class LuceneRangeTest
extends BaseLuceneTest {
    @Before
    public void setUp() throws Exception {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass cls = schema.createClass("Person");
        cls.createProperty("name", OType.STRING);
        cls.createProperty("surname", OType.STRING);
        cls.createProperty("date", OType.DATETIME);
        cls.createProperty("age", OType.INTEGER);
        List<String> names = Arrays.asList("John", "Robert", "Jane", "andrew", "Scott", "luke", "Enriquez", "Luis", "Gabriel", "Sara");
        for (int i = 0; i < 10; ++i) {
            this.db.save((ORecord)new ODocument("Person").field("name", (Object)names.get(i)).field("surname", (Object)"Reese").field("date", (Object)(System.currentTimeMillis() - (long)(i * 3600 * 24 * 1000))).field("age", (Object)i));
        }
    }

    @Test
    public void shouldUseRangeQueryOnSingleIntegerField() throws Exception {
        this.db.command((OCommandRequest)new OCommandSQL("create index Person.age on Person(age) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        Assertions.assertThat((long)this.db.getMetadata().getIndexManager().getIndex("Person.age").getSize()).isEqualTo(11L);
        Collection results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT FROM Person WHERE age LUCENE 'age:[5 TO 6]'")).execute(new Object[0]);
        Assertions.assertThat((Iterable)results).hasSize(2);
        results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT FROM Person WHERE age LUCENE 'age:5'")).execute(new Object[0]);
        Assertions.assertThat((Iterable)results).hasSize(1);
    }

    @Test
    public void shouldUseRangeQueryOnSingleDateField() throws Exception {
        this.db.commit();
        this.db.command((OCommandRequest)new OCommandSQL("create index Person.date on Person(date) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        this.db.commit();
        Assertions.assertThat((long)this.db.getMetadata().getIndexManager().getIndex("Person.date").getSize()).isEqualTo(11L);
        String today = DateTools.timeToString((long)System.currentTimeMillis(), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        String fiveDaysAgo = DateTools.timeToString((long)(System.currentTimeMillis() - 432000000L), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        Collection results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT FROM Person WHERE date LUCENE 'date:[" + fiveDaysAgo + " TO " + today + "]'")).execute(new Object[0]);
        Assertions.assertThat((Iterable)results).hasSize(5);
    }

    @Test
    public void shouldUseRangeQueryMultipleField() throws Exception {
        this.db.command((OCommandRequest)new OCommandSQL("create index Person.composite on Person(name,surname,date,age) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        Assertions.assertThat((long)this.db.getMetadata().getIndexManager().getIndex("Person.composite").getSize()).isEqualTo(11L);
        this.db.commit();
        String today = DateTools.timeToString((long)System.currentTimeMillis(), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        String fiveDaysAgo = DateTools.timeToString((long)(System.currentTimeMillis() - 432000000L), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        Collection results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT * FROM Person WHERE [name,surname,date,age] LUCENE 'age:[5 TO 6] name:robert  '")).execute(new Object[0]);
        Assertions.assertThat((Iterable)results).hasSize(3);
        results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT FROM Person WHERE [name,surname,date,age] LUCENE 'date:[" + fiveDaysAgo + " TO " + today + "]'")).execute(new Object[0]);
        Assertions.assertThat((Iterable)results).hasSize(5);
        results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT FROM Person WHERE [name,surname,date,age] LUCENE '+age:[4 TO 7]  +date:[" + fiveDaysAgo + " TO " + today + "]'")).execute(new Object[0]);
        Assertions.assertThat((Iterable)results).hasSize(2);
    }

    @Test
    public void shouldUseRangeQueryMultipleFieldWithDirectIndexAccess() throws Exception {
        this.db.command((OCommandRequest)new OCommandSQL("create index Person.composite on Person(name,surname,date,age) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        Assertions.assertThat((long)this.db.getMetadata().getIndexManager().getIndex("Person.composite").getSize()).isEqualTo(11L);
        this.db.commit();
        String today = DateTools.timeToString((long)System.currentTimeMillis(), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        String fiveDaysAgo = DateTools.timeToString((long)(System.currentTimeMillis() - 432000000L), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        Collection results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT * FROM index:Person.composite WHERE key ='name:luke  age:[5 TO 6]'")).execute(new Object[0]);
        Assertions.assertThat((Iterable)results).hasSize(2);
        results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT FROM index:Person.composite WHERE key = 'date:[" + fiveDaysAgo + " TO " + today + "]'")).execute(new Object[0]);
        Assertions.assertThat((Iterable)results).hasSize(5);
        results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT FROM index:Person.composite WHERE key = '+age:[4 TO 7]  +date:[" + fiveDaysAgo + " TO " + today + "]'")).execute(new Object[0]);
        Assertions.assertThat((Iterable)results).hasSize(2);
    }

    @Test
    public void shouldFetchOnlyFromACluster() throws Exception {
        this.db.command((OCommandRequest)new OCommandSQL("create index Person.name on Person(name) FULLTEXT ENGINE LUCENE")).execute(new Object[0]);
        Assertions.assertThat((long)this.db.getMetadata().getIndexManager().getIndex("Person.name").getSize()).isEqualTo(11L);
        int cluster = this.db.getMetadata().getSchema().getClass("Person").getClusterIds()[1];
        this.db.commit();
        Collection results = (Collection)this.db.command((OCommandRequest)new OCommandSQL("SELECT FROM Person WHERE name LUCENE '+_CLUSTER:" + cluster + "'")).execute(new Object[0]);
        Assertions.assertThat((Iterable)results).hasSize(2);
    }
}

