/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.InputStream;
import java.util.List;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class LuceneQeuryParserTest
extends BaseLuceneTest {
    @Before
    public void init() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("testLuceneIndex.sql");
        this.db.command((OCommandRequest)new OCommandScript("sql", this.getScriptFromStream(stream))).execute(new Object[0]);
    }

    @Test
    public void shouldSearchWithLeadingWildcard() {
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.title on Song (title) FULLTEXT ENGINE LUCENE metadata {\"allowLeadingWildcard\": true}")).execute(new Object[0]);
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where [title] LUCENE \"(title:*tain)\""), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(4);
    }

    @Test
    public void shouldSearchWithLowercaseExpandedTerms() {
        this.db.command((OCommandRequest)new OCommandSQL("create index Song.author on Song (author) FULLTEXT ENGINE LUCENE metadata {\"default\": \"" + KeywordAnalyzer.class.getCanonicalName() + "\", \"lowercaseExpandedTerms\": false}")).execute(new Object[0]);
        List docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where [author] LUCENE \"Hunter\""), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(97);
        docs = this.db.query((OQuery)new OSQLSynchQuery("select * from Song where [author] LUCENE \"HUNTER\""), new Object[0]);
        Assertions.assertThat((List)docs).hasSize(0);
    }
}

