/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OLegacyResultSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class LucenePhraseQueriesTest
extends BaseLuceneTest {
    @Before
    public void setUp() throws Exception {
        OClass type = this.db.createVertexClass("Role");
        type.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("create index Role.name on Role (name) FULLTEXT ENGINE LUCENE METADATA{\"name_index\": \"org.apache.lucene.analysis.standard.StandardAnalyzer\",\"name_index_stopwords\": \"[]\",\"name_query\": \"org.apache.lucene.analysis.standard.StandardAnalyzer\",\"name_query_stopwords\": \"[]\"} ")).execute(new Object[0]);
        OVertex role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"System IT Owner");
        this.db.save((ORecord)role);
        role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"System Business Owner");
        this.db.save((ORecord)role);
        role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"System Business SME");
        this.db.save((ORecord)role);
        role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"System Technical SME");
        this.db.save((ORecord)role);
        role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"System");
        this.db.save((ORecord)role);
        role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"boat");
        this.db.save((ORecord)role);
        role = this.db.newVertex("Role");
        role.setProperty("name", (Object)"moat");
        this.db.save((ORecord)role);
    }

    @Test
    public void testPhraseQueries() throws Exception {
        OLegacyResultSet vertexes = (OLegacyResultSet)this.db.command((OCommandRequest)new OCommandSQL("select from Role where name lucene ' \"Business Owner\" '  ")).execute(new Object[0]);
        Assertions.assertThat((List)vertexes).hasSize(1);
        vertexes = (OLegacyResultSet)this.db.command((OCommandRequest)new OCommandSQL("select from Role where name lucene ' \"Owner of Business\" '  ")).execute(new Object[0]);
        Assertions.assertThat((List)vertexes).hasSize(0);
        vertexes = (OLegacyResultSet)this.db.command((OCommandRequest)new OCommandSQL("select from Role where name lucene ' \"System Owner\" '  ")).execute(new Object[0]);
        Assertions.assertThat((List)vertexes).hasSize(0);
        vertexes = (OLegacyResultSet)this.db.command((OCommandRequest)new OCommandSQL("select from Role where name lucene ' \"System SME\"~1 '  ")).execute(new Object[0]);
        Assertions.assertThat((List)vertexes).hasSize(2);
        vertexes = (OLegacyResultSet)this.db.command((OCommandRequest)new OCommandSQL("select from Role where name lucene ' \"System Business\"~1 '  ")).execute(new Object[0]);
        Assertions.assertThat((List)vertexes).hasSize(2);
        vertexes = (OLegacyResultSet)this.db.command((OCommandRequest)new OCommandSQL("select from Role where name lucene ' /[mb]oat/ '  ")).execute(new Object[0]);
        Assertions.assertThat((List)vertexes).hasSize(2);
    }

    @Test
    public void testComplexPhraseQueries() throws Exception {
        Iterable vertexes = (Iterable)this.db.command((OCommandRequest)new OCommandSQL("select from Role where name lucene ?")).execute(new Object[]{"\"System SME\"~1"});
        Assertions.assertThat((Iterable)vertexes).allMatch(v -> ((String)v.getProperty("name")).contains("SME"));
        vertexes = (Iterable)this.db.command((OCommandRequest)new OCommandSQL("select from Role where name lucene ? ")).execute(new Object[]{"\"SME System\"~1"});
        Assertions.assertThat((Iterable)vertexes).isEmpty();
        vertexes = (Iterable)this.db.command((OCommandRequest)new OCommandSQL("select from Role where name lucene ? ")).execute(new Object[]{"\"Owner Of Business\""});
        vertexes.forEach(v -> System.out.println("v = " + v.getProperty("name")));
        Assertions.assertThat((Iterable)vertexes).isEmpty();
        vertexes = (Iterable)this.db.command((OCommandRequest)new OCommandSQL("select from Role where name lucene ? ")).execute(new Object[]{"\"System Business SME\""});
        Assertions.assertThat((Iterable)vertexes).hasSize(1).allMatch(v -> ((String)v.getProperty("name")).equalsIgnoreCase("System Business SME"));
        vertexes = (Iterable)this.db.command((OCommandRequest)new OCommandSQL("select from Role where name lucene ? ")).execute(new Object[]{"\"System Owner\"~1 -IT"});
        Assertions.assertThat((Iterable)vertexes).hasSize(1).allMatch(v -> ((String)v.getProperty("name")).equalsIgnoreCase("System Business Owner"));
        vertexes = (Iterable)this.db.command((OCommandRequest)new OCommandSQL("select from Role where name lucene ? ")).execute(new Object[]{"+System +Own*~0.0 -IT"});
        Assertions.assertThat((Iterable)vertexes).hasSize(1).allMatch(v -> ((String)v.getProperty("name")).equalsIgnoreCase("System Business Owner"));
        vertexes = (Iterable)this.db.command((OCommandRequest)new OCommandSQL("select from Role where name lucene ? ")).execute(new Object[]{"\"System Owner\"~1 -Business"});
        Assertions.assertThat((Iterable)vertexes).hasSize(1).allMatch(v -> ((String)v.getProperty("name")).equalsIgnoreCase("System IT Owner"));
    }
}

