/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.test;

import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import org.junit.Assert;
import org.junit.Test;

public class LuceneNullTest
extends BaseLuceneTest {
    @Test
    public void testNullChangeToNotNullWithLists() {
        this.db.command((OCommandRequest)new OCommandSQL("create class Test extends V")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property Test.names EMBEDDEDLIST STRING")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Test.names on Test (names) fulltext engine lucene")).execute(new Object[0]);
        this.db.begin();
        ODocument doc = new ODocument("Test");
        this.db.save((ORecord)doc);
        this.db.commit();
        this.db.begin();
        doc.field("names", (Object)new String[]{"foo"});
        this.db.save((ORecord)doc);
        this.db.commit();
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("Test.names");
        Assert.assertEquals((long)2L, (long)index.getSize());
    }

    @Test
    public void testNotNullChangeToNullWithLists() {
        this.db.command((OCommandRequest)new OCommandSQL("create class Test extends V")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property Test.names EMBEDDEDLIST STRING")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Test.names on Test (names) fulltext engine lucene")).execute(new Object[0]);
        ODocument doc = new ODocument("Test");
        this.db.begin();
        doc.field("names", (Object)new String[]{"foo"});
        this.db.save((ORecord)doc);
        this.db.commit();
        this.db.begin();
        doc.removeField("names");
        this.db.save((ORecord)doc);
        this.db.commit();
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("Test.names");
        Assert.assertEquals((long)index.getSize(), (long)1L);
    }
}

